/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableKey;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableLockService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergCatalog;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergInternalTableService;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;

public class IcebergTableService {
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergNamespaceService namespaceService;
    private final IcebergInternalTableService tableService;
    private final IcebergTableLockService tableLockService;

    @Inject
    public IcebergTableService(IcebergCatalogService icebergCatalogService, IcebergNamespaceService namespaceService, IcebergInternalTableService tableService, IcebergTableLockService tableLockService) {
        this.icebergCatalogService = Objects.requireNonNull(icebergCatalogService, "icebergCatalogService");
        this.namespaceService = Objects.requireNonNull(namespaceService, "namespaceService");
        this.tableService = Objects.requireNonNull(tableService, "tableService");
        this.tableLockService = Objects.requireNonNull(tableLockService, "tableLockService");
    }

    public IcebergObjectInfo getObjectForApi(String catalogName, String namespaceName, String objectName) {
        catalogName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        namespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        objectName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, objectName);
        return this.tableService.getObjectForApi(catalogName, namespaceName, objectName);
    }

    public IcebergObjectListResponse listObjectsForApi(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        catalogName = catalogName.map(name -> CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_CATALOG, name));
        namespaceName = namespaceName.map(name -> CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, name));
        return this.tableService.listObjectsForApi(catalogName, namespaceName, objectType, page);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, Set<String> tableNames) {
        catalogName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        return this.tableService.listMaterializedViewsForRewriteForApi(catalogName, tableNames);
    }

    public LoadTableResponse createTable(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, CreateTableRequest request) {
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, request.name(), IcebergTableType.TABLE), () -> {
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                Namespace icebergNamespace = Namespace.of((String[])new String[]{namespaceContext.namespaceName()});
                if (request.stageCreate()) {
                    return CatalogHandlers.stageTableCreate((Catalog)catalog, (Namespace)icebergNamespace, (CreateTableRequest)request);
                }
                return CatalogHandlers.createTable((Catalog)catalog, (Namespace)icebergNamespace, (CreateTableRequest)request);
            }));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public LoadTableResponse registerTable(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, RegisterTableRequest request) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, request.name());
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, normalizedName, IcebergTableType.TABLE), () -> {
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                Namespace icebergNamespace = Namespace.of((String[])new String[]{namespaceContext.namespaceName()});
                return CatalogHandlers.registerTable((Catalog)catalog, (Namespace)icebergNamespace, (RegisterTableRequest)request);
            }));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public LoadTableResponse updateTable(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String tableName, UpdateTableRequest request) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, tableName, IcebergTableType.TABLE), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                return CatalogHandlers.updateTable((Catalog)catalog, (TableIdentifier)tableIdentifier, (UpdateTableRequest)request);
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
            throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedName, Optional.of("table"));
        }
    }

    public void renameTable(AuthenticatedPrincipal currentPrincipal, String catalogName, RenameTableRequest request) {
        this.rename(currentPrincipal, catalogName, request, IcebergTableType.TABLE);
    }

    public void dropTable(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String tableName, boolean purge) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        try {
            this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, tableName, IcebergTableType.TABLE), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                if (purge) {
                    CatalogHandlers.purgeTable((Catalog)catalog, (TableIdentifier)tableIdentifier);
                } else {
                    CatalogHandlers.dropTable((Catalog)catalog, (TableIdentifier)tableIdentifier);
                }
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, IcebergTableType.TABLE);
        }
    }

    public LoadTableResponse loadTable(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String tableName) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withReadLock(IcebergTableService.lockKey(namespaceContext, tableName, IcebergTableType.TABLE), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                return CatalogHandlers.loadTable((Catalog)catalog, (TableIdentifier)tableIdentifier);
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, IcebergTableType.TABLE);
        }
    }

    public void tableExists(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String tableName) {
        this.exists(currentPrincipal, catalogName, namespaceName, tableName, IcebergTableType.TABLE);
    }

    public ListTablesResponse listTables(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, ResultPage page) {
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableService.list((IcebergNamespaceContext)namespaceContext, IcebergTableType.TABLE, page));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public LoadViewResponse createView(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, CreateViewRequest request) {
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, request.name(), IcebergTableType.VIEW), () -> {
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                Namespace icebergNamespace = Namespace.of((String[])new String[]{namespaceContext.namespaceName()});
                return CatalogHandlers.createView((ViewCatalog)catalog, (Namespace)icebergNamespace, (CreateViewRequest)request);
            }));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    public LoadViewResponse updateView(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String viewName, UpdateTableRequest request) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, viewName, IcebergTableType.VIEW), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                return CatalogHandlers.updateView((ViewCatalog)catalog, (TableIdentifier)tableIdentifier, (UpdateTableRequest)request);
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
            throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedName, Optional.of("view"));
        }
    }

    public void renameView(AuthenticatedPrincipal currentPrincipal, String catalogName, RenameTableRequest request) {
        this.rename(currentPrincipal, catalogName, request, IcebergTableType.VIEW);
    }

    public void dropView(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String viewName) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        try {
            this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withWriteLock(IcebergTableService.lockKey(namespaceContext, viewName, IcebergTableType.VIEW), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                CatalogHandlers.dropView((ViewCatalog)catalog, (TableIdentifier)tableIdentifier);
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, IcebergTableType.VIEW);
        }
    }

    public LoadViewResponse loadView(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String viewName) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withReadLock(IcebergTableService.lockKey(namespaceContext, viewName, IcebergTableType.VIEW), () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                return CatalogHandlers.loadView((ViewCatalog)catalog, (TableIdentifier)tableIdentifier);
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, IcebergTableType.VIEW);
        }
    }

    public void viewExists(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String viewName) {
        this.exists(currentPrincipal, catalogName, namespaceName, viewName, IcebergTableType.VIEW);
    }

    public ListTablesResponse listViews(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, ResultPage page) {
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableService.list((IcebergNamespaceContext)namespaceContext, IcebergTableType.VIEW, page));
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    private void rename(AuthenticatedPrincipal currentPrincipal, String catalogName, RenameTableRequest request, IcebergTableType type) {
        String normalizedSourceNamespace = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, request.source().namespace().level(0));
        String normalizedSourceTable = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, request.source().name());
        String normalizedDestinationNamespace = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, request.destination().namespace().level(0));
        String normalizedDestinationTable = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, request.destination().name());
        try {
            this.icebergCatalogService.execute(currentPrincipal, catalogName, catalogContext -> {
                AtomicBoolean remapException = new AtomicBoolean(true);
                try {
                    this.namespaceService.execute((IcebergCatalogContext)catalogContext, normalizedSourceNamespace, sourceNamespaceContext -> {
                        remapException.set(false);
                        this.namespaceService.execute((IcebergCatalogContext)catalogContext, normalizedDestinationNamespace, destinationNamespaceContext -> {
                            IcebergTableKey sourceKey = IcebergTableService.lockKey(sourceNamespaceContext, normalizedSourceTable, type);
                            IcebergTableKey destinationKey = IcebergTableService.lockKey(destinationNamespaceContext, normalizedDestinationTable, type);
                            this.tableLockService.withWriteLock(sourceKey, destinationKey, () -> {
                                boolean renamed = this.tableService.rename(catalogContext.catalogName(), (IcebergNamespaceContext)sourceNamespaceContext, normalizedSourceTable, (IcebergNamespaceContext)destinationNamespaceContext, normalizedDestinationTable, type);
                                if (!renamed) {
                                    throw IcebergTableService.tableOrViewNotExists(normalizedSourceNamespace, normalizedSourceTable, type);
                                }
                            });
                        });
                    });
                }
                catch (IcebergNamespaceDoesNotExistException e) {
                    if (remapException.get()) {
                        throw IcebergTableService.tableOrViewNotExists(normalizedSourceNamespace, normalizedSourceTable, type);
                    }
                    throw e;
                }
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(normalizedSourceNamespace, normalizedSourceTable, type);
        }
    }

    private void exists(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String name, IcebergTableType type) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, name);
        try {
            this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withReadLock(IcebergTableService.lockKey(namespaceContext, name, type), () -> {
                Optional<String> metadataLocation = this.tableService.currentMetadataLocation((IcebergNamespaceContext)namespaceContext, namespaceName, type);
                if (metadataLocation.isEmpty()) {
                    throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, type);
                }
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.tableOrViewNotExists(namespaceName, normalizedName, type);
        }
    }

    public LoadObjectResponse loadObject(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, String objectName) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, objectName);
        try {
            return this.namespaceService.execute(currentPrincipal, catalogName, namespaceName, namespaceContext -> this.tableLockService.withReadLock(IcebergTableService.lockKey(namespaceContext, objectName, IcebergTableType.TABLE), () -> {
                TableIdentifier identifier = TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), normalizedName});
                IcebergCatalog catalog = this.asCatalog((IcebergNamespaceContext)namespaceContext);
                Optional<LoadTableResponse> table = this.tryLoadTable(catalog, identifier);
                Optional<Object> view = Optional.empty();
                if (table.isEmpty()) {
                    view = this.tryLoadView(catalog, identifier);
                }
                return new LoadObjectResponse(identifier, table.map(LoadTableResponse::tableMetadata), table.map(LoadTableResponse::metadataLocation), view.map(LoadViewResponse::metadata), view.map(LoadViewResponse::metadataLocation));
            }));
        }
        catch (IcebergCatalogDoesNotExistException | IcebergNamespaceDoesNotExistException e) {
            throw IcebergTableService.namespaceNotExists(namespaceName);
        }
    }

    private Optional<LoadTableResponse> tryLoadTable(IcebergCatalog catalog, TableIdentifier tableIdentifier) {
        try {
            return Optional.of(CatalogHandlers.loadTable((Catalog)catalog, (TableIdentifier)tableIdentifier));
        }
        catch (NoSuchTableException e) {
            return Optional.empty();
        }
    }

    private Optional<LoadViewResponse> tryLoadView(IcebergCatalog catalog, TableIdentifier tableIdentifier) {
        try {
            return Optional.of(CatalogHandlers.loadView((ViewCatalog)catalog, (TableIdentifier)tableIdentifier));
        }
        catch (NoSuchViewException e) {
            return Optional.empty();
        }
    }

    @VisibleForTesting
    public IcebergCatalog asCatalog(IcebergNamespaceContext namespaceContext) {
        return this.tableService.asCatalog(namespaceContext);
    }

    private static IcebergNamespaceDoesNotExistException namespaceNotExists(String namespaceName) {
        return new IcebergNamespaceDoesNotExistException(CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName));
    }

    private static CatalogException tableOrViewNotExists(String namespaceName, String tableName, IcebergTableType tableType) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        String normalizedTableName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        Optional<String> objectType = tableType == IcebergTableType.TABLE ? Optional.of("table") : (tableType == IcebergTableType.VIEW ? Optional.of("view") : Optional.empty());
        throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedTableName, objectType);
    }

    private static IcebergTableKey lockKey(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        name = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, name);
        return new IcebergTableKey(namespaceContext.catalogId(), namespaceContext.namespaceId(), name, type);
    }
}

