/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableKey;

public class IcebergTableLockService {
    private static final int STRIPE_COUNT = 128;
    private final boolean enabled;
    private final ReentrantReadWriteLock[] locks;

    public IcebergTableLockService(boolean enabled) {
        this.enabled = enabled;
        this.locks = new ReentrantReadWriteLock[128];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    public void withReadLock(IcebergTableKey key, Runnable command) {
        this.withReadLock(key, () -> {
            command.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withReadLock(IcebergTableKey key, Supplier<T> command) {
        if (!this.enabled) {
            return command.get();
        }
        int index = this.index(key);
        this.locks[index].readLock().lock();
        try {
            T t = command.get();
            return t;
        }
        finally {
            this.locks[index].readLock().unlock();
        }
    }

    public void withWriteLock(IcebergTableKey key, Runnable command) {
        this.withWriteLock(key, () -> {
            command.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withWriteLock(IcebergTableKey key, Supplier<T> command) {
        if (!this.enabled) {
            return command.get();
        }
        int index = this.index(key);
        this.locks[index].writeLock().lock();
        try {
            T t = command.get();
            return t;
        }
        finally {
            this.locks[index].writeLock().unlock();
        }
    }

    public void withWriteLock(IcebergTableKey key1, IcebergTableKey key2, Runnable command) {
        this.withWriteLock(key1, key2, () -> {
            command.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withWriteLock(IcebergTableKey key1, IcebergTableKey key2, Supplier<T> command) {
        int index2;
        if (!this.enabled) {
            return command.get();
        }
        int index1 = this.index(key1);
        if (index1 == (index2 = this.index(key2))) {
            this.locks[index1].writeLock().lock();
            try {
                T t = command.get();
                return t;
            }
            finally {
                this.locks[index1].writeLock().unlock();
            }
        }
        if (index2 < index1) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        this.locks[index1].writeLock().lock();
        this.locks[index2].writeLock().lock();
        try {
            T t = command.get();
            return t;
        }
        finally {
            this.locks[index1].writeLock().unlock();
            this.locks[index2].writeLock().unlock();
        }
    }

    private int index(IcebergTableKey key) {
        return Math.abs(key.hashCode()) % this.locks.length;
    }
}

