/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import java.util.Optional;
import java.util.UUID;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;

public record IcebergTableKey(UUID catalogId, UUID namespaceId, String name, IcebergTableType type) {
    public String toCacheKey(Optional<String> classifier) {
        return this.type.getIdentifier() + "." + String.valueOf(this.catalogId) + "." + String.valueOf(this.namespaceId) + "." + this.name + (String)(classifier.isPresent() ? "(" + classifier.get() + ")" : "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableKey that = (IcebergTableKey)o;
        return this.namespaceId.equals(that.namespaceId) && this.name.equals(that.name) && this.type.equals((Object)that.type) && this.catalogId.equals(that.catalogId);
    }

    @Override
    public int hashCode() {
        int result = this.catalogId.hashCode();
        result = 31 * result + this.namespaceId.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.toCacheKey(Optional.empty());
    }
}

