/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.iceberg.rest.AbstractIcebergResource;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;

@ResourceType(value=ResourceType.Type.ICEBERG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/catalog/iceberg/v1")
public class IcebergViewResource
extends AbstractIcebergResource {
    @Inject
    public IcebergViewResource(EmbeddedInternalCatalogClientFactory clientFactory) {
        super(clientFactory);
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/views")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createView(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, CreateViewRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        LoadViewResponse result = this.createClient(securityContext).restIcebergCreateView(catalogName, namespace, request);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/views/{view}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response replaceView(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="view") String viewName, UpdateTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        viewName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        LoadViewResponse response = this.createClient(securityContext).restIcebergReplaceView(catalogName, namespace, viewName, request);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/{prefix}/views/rename")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response renameView(@PathParam(value="prefix") String catalogName, RenameTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        this.createClient(securityContext).restIcebergRenameView(catalogName, request);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{prefix}/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    public Response dropView(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="view") String viewName, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        viewName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        this.createClient(securityContext).restIcebergDropView(catalogName, namespace, viewName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    public Response loadView(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="view") String viewName, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        viewName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        LoadViewResponse response = this.createClient(securityContext).restIcebergLoadView(catalogName, namespace, viewName);
        return Response.ok((Object)response).build();
    }

    @HEAD
    @Path(value="/{prefix}/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    public Response viewExists(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="view") String viewName, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        viewName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewName);
        this.createClient(securityContext).restIcebergViewExists(catalogName, namespace, viewName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}/views")
    @Produces(value={"application/json"})
    public Response listViews(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ListTablesResponse response = this.createClient(securityContext).restIcebergListViews(catalogName, namespace, page);
        return Response.ok((Object)response).build();
    }
}

