/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.iceberg.rest.AbstractIcebergResource;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;

@ResourceType(value=ResourceType.Type.ICEBERG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/catalog/iceberg/v1")
public class IcebergTableResource
extends AbstractIcebergResource {
    @Inject
    public IcebergTableResource(EmbeddedInternalCatalogClientFactory clientFactory) {
        super(clientFactory);
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/tables")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTable(@HeaderParam(value="X-Iceberg-Access-Delegation") String accessDelegation, @PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, CreateTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        LoadTableResponse result = this.createClient(securityContext).restIcebergCreateTable(catalogName, namespace, request, accessDelegation);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/register")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerTable(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, RegisterTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        LoadTableResponse result = this.createClient(securityContext).restIcebergRegisterTable(catalogName, namespace, request);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/tables/{table}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTable(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="table") String tableName, UpdateTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        tableName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        LoadTableResponse response = this.createClient(securityContext).restIcebergUpdateTable(catalogName, namespace, tableName, request);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/{prefix}/tables/rename")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response renameTable(@PathParam(value="prefix") String catalogName, RenameTableRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        this.createClient(securityContext).restIcebergRenameTable(catalogName, request);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{prefix}/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    public Response dropTable(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="table") String tableName, @QueryParam(value="purgeRequested") @DefaultValue(value="false") Boolean purgeRequested, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        tableName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        if (purgeRequested == null) {
            purgeRequested = false;
        }
        this.createClient(securityContext).restIcebergDropTable(catalogName, namespace, tableName, purgeRequested);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    public Response loadTable(@HeaderParam(value="X-Iceberg-Access-Delegation") String icebergAccessDelegation, @PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="table") String tableName, @QueryParam(value="snapshots") String snapshots, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        tableName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        LoadTableResponse response = this.createClient(securityContext).restIcebergLoadTable(catalogName, namespace, tableName, snapshots, icebergAccessDelegation);
        return Response.ok((Object)response).build();
    }

    @HEAD
    @Path(value="/{prefix}/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    public Response tableExists(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="table") String tableName, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        tableName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableName);
        this.createClient(securityContext).restIcebergTableExists(catalogName, namespace, tableName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}/tables")
    @Produces(value={"application/json"})
    public Response listTables(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        catalogName = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalogName);
        Namespace namespace = CatalogUtils.decodeIcebergNamespace(namespaceName);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ListTablesResponse response = this.createClient(securityContext).restIcebergListTables(catalogName, namespace, page);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/tables/{table}/metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reportMetrics(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="table") String tableName, ReportMetricsRequest request, @Context SecurityContext securityContext) {
        return Response.noContent().build();
    }
}

