/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.oauth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OAuthErrorType {
    INVALID_REQUEST("invalid_request", 500),
    INVALID_CLIENT("invalid_client", 400),
    INVALID_GRANT("invalid_grant", 400),
    UNAUTHORIZED_CLIENT("unauthorized_client", 401),
    UNSUPPORTED_GRANT_TYPE("unsupported_grant_type", 400),
    INVALID_SCOPE("invalid_scope", 400);

    private final String value;
    private final int httpCode;

    private OAuthErrorType(String value, int httpCode) {
        this.value = value;
        this.httpCode = httpCode;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    @JsonCreator
    public static OAuthErrorType fromValue(String valueStr) {
        for (OAuthErrorType value : OAuthErrorType.values()) {
            if (!value.value.equals(valueStr)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unexpected value '" + valueStr + "'");
    }

    @JsonValue
    public String toString() {
        return this.value;
    }
}

