/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.namespace;

import com.google.inject.Inject;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceListResult;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespacePropertiesUpdateResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogPropertyConflictException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.store.CatalogStore;

public class IcebergNamespaceService {
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final CatalogStore store;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final Lock lock = new ReentrantLock();
    private final ConcurrentHashMap<NamespaceKey, IcebergNamespaceDetails> namespaces = new ConcurrentHashMap();

    @Inject
    public IcebergNamespaceService(IcebergCatalogService icebergCatalogService, IcebergTableMetadataCache tableMetadataCache, CatalogStore store) {
        this.icebergCatalogService = Objects.requireNonNull(icebergCatalogService, "icebergCatalogService");
        this.tableMetadataCache = Objects.requireNonNull(tableMetadataCache, "tableMetadataCache");
        this.store = Objects.requireNonNull(store, "store");
    }

    @PostConstruct
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        this.lock.lock();
        try {
            for (IcebergNamespaceDetails info : this.store.listIcebergNamespaceDetails()) {
                this.namespaces.put(new NamespaceKey(info.catalogId(), info.namespaceName()), info);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public IcebergNamespaceDetails createNamespace(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, Map<String, String> properties) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        return this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> {
            this.lock.lock();
            try {
                Map<String, String> normalizedProperties = IcebergNamespaceService.normalizeProperties(icebergCatalogContext, normalizedNamespaceName, properties);
                NamespaceKey key = new NamespaceKey(icebergCatalogContext.catalogId(), normalizedNamespaceName);
                if (this.namespaces.containsKey(key)) {
                    throw new IcebergNamespaceAlreadyExistsException(normalizedNamespaceName);
                }
                Optional<UUID> namespaceId = this.store.createIcebergNamespaceIfNotExists(normalizedNamespaceName, icebergCatalogContext.catalogId(), icebergCatalogContext.catalogName(), normalizedProperties);
                if (namespaceId.isEmpty()) {
                    throw new IcebergNamespaceAlreadyExistsException(normalizedNamespaceName);
                }
                IcebergNamespaceDetails info = new IcebergNamespaceDetails(namespaceId.get(), normalizedNamespaceName, icebergCatalogContext.catalogId(), normalizedProperties);
                this.namespaces.put(key, info);
                IcebergNamespaceDetails icebergNamespaceDetails = info;
                return icebergNamespaceDetails;
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public IcebergNamespacePropertiesUpdateResult updateNamespaceProperties(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, Map<String, String> updates, Collection<String> removals) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        if (removals != null) {
            for (String removal : removals) {
                if (!updates.containsKey(removal)) continue;
                throw new CatalogPropertyConflictException(removal);
            }
        }
        try {
            return this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> {
                this.lock.lock();
                try {
                    NamespaceKey key = new NamespaceKey(icebergCatalogContext.catalogId(), normalizedNamespaceName);
                    IcebergNamespaceDetails namespace = this.namespaces.get(key);
                    if (namespace == null) {
                        throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
                    }
                    HashSet<String> removed = new HashSet<String>();
                    Map<String, String> newProperties = new HashMap<String, String>();
                    if (namespace.properties() != null) {
                        newProperties.putAll(namespace.properties());
                    }
                    if (updates != null) {
                        newProperties.putAll(updates);
                    }
                    if (removals != null) {
                        for (String removal : removals) {
                            if (newProperties.remove(removal) == null) continue;
                            removed.add(removal);
                        }
                    }
                    newProperties = IcebergNamespaceService.normalizeProperties(icebergCatalogContext, normalizedNamespaceName, newProperties);
                    boolean updated = this.store.updateIcebergNamespaceIfExists(namespace.namespaceId(), newProperties);
                    if (!updated) {
                        throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
                    }
                    IcebergNamespaceDetails newNamespace = new IcebergNamespaceDetails(namespace.namespaceId(), namespace.namespaceName(), namespace.catalogId(), newProperties);
                    this.namespaces.put(key, newNamespace);
                    IcebergNamespacePropertiesUpdateResult icebergNamespacePropertiesUpdateResult = new IcebergNamespacePropertiesUpdateResult(updates != null ? new HashSet(updates.keySet()) : Set.of(), removed);
                    return icebergNamespacePropertiesUpdateResult;
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public void deleteNamespace(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        try {
            this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> {
                this.lock.lock();
                try {
                    NamespaceKey key = new NamespaceKey(icebergCatalogContext.catalogId(), normalizedNamespaceName);
                    IcebergNamespaceDetails namespace = this.namespaces.get(key);
                    if (namespace == null) {
                        throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
                    }
                    boolean deleted = this.store.deleteIcebergNamespaceIfExists(namespace.namespaceId(), normalizedNamespaceName, icebergCatalogContext.catalogName());
                    if (!deleted) {
                        throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
                    }
                    this.namespaces.remove(key);
                    this.tableMetadataCache.invalidateNamespace(namespace.namespaceId());
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public IcebergNamespaceDetails getNamespace(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName) {
        try {
            String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
            return this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> {
                NamespaceKey key = new NamespaceKey(icebergCatalogContext.catalogId(), normalizedNamespaceName);
                IcebergNamespaceDetails namespace = this.namespaces.get(key);
                if (namespace == null) {
                    throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
                }
                return namespace;
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public IcebergNamespaceListResponse listNamespacesForApi(Optional<String> catalogName, ResultPage page) {
        return this.store.listIcebergNamespacesForApi(catalogName, page);
    }

    public IcebergNamespaceListResult listNamespaces(AuthenticatedPrincipal currentPrincipal, String catalogName, ResultPage page) {
        return this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> this.store.listIcebergNamespaces(icebergCatalogContext.catalogId(), page));
    }

    public <T> T execute(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, Function<IcebergNamespaceContext, T> action) {
        return (T)this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> this.execute((IcebergCatalogContext)icebergCatalogContext, namespaceName, action));
    }

    public <T> T execute(IcebergCatalogContext icebergCatalogContext, String namespaceName, Function<IcebergNamespaceContext, T> action) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName);
        NamespaceKey key = new NamespaceKey(icebergCatalogContext.catalogId(), normalizedNamespaceName);
        IcebergNamespaceDetails namespaceInfo = this.namespaces.get(key);
        if (namespaceInfo == null) {
            throw new IcebergNamespaceDoesNotExistException(normalizedNamespaceName);
        }
        IcebergNamespaceContext namespaceContext = new IcebergNamespaceContext(icebergCatalogContext, namespaceInfo);
        return action.apply(namespaceContext);
    }

    public void execute(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, Consumer<IcebergNamespaceContext> action) {
        this.execute(currentPrincipal, catalogName, namespaceName, (IcebergNamespaceContext namespaceContext) -> {
            action.accept((IcebergNamespaceContext)namespaceContext);
            return null;
        });
    }

    public void execute(IcebergCatalogContext icebergCatalogContext, String namespaceName, Consumer<IcebergNamespaceContext> action) {
        this.execute(icebergCatalogContext, namespaceName, (IcebergNamespaceContext namespaceContext) -> {
            action.accept((IcebergNamespaceContext)namespaceContext);
            return null;
        });
    }

    private static Map<String, String> normalizeProperties(IcebergCatalogContext icebergCatalogContext, String namespaceName, Map<String, String> properties) {
        if (properties == null) {
            properties = Map.of();
        }
        if (!properties.containsKey("location")) {
            properties = new HashMap<String, String>(properties);
            properties.put("location", icebergCatalogContext.catalogInfo().resolveFileSystemLocationSuffix(namespaceName));
        }
        return properties;
    }

    private static IcebergNamespaceDoesNotExistException namespaceNotExists(String namespaceName) {
        return new IcebergNamespaceDoesNotExistException(CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, namespaceName));
    }

    private record NamespaceKey(UUID catalogId, String namespaceName) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespaceKey that = (NamespaceKey)o;
            return this.namespaceName.equals(that.namespaceName) && this.catalogId.equals(that.catalogId);
        }

        @Override
        public int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + this.namespaceName.hashCode();
            return result;
        }
    }
}

