/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.io;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergInputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemOutputFile;

public class CatalogIcebergOutputFile
implements OutputFile {
    private final CatalogFileSystem fileSystem;
    private final CatalogFileSystemOutputFile outputFile;

    public CatalogIcebergOutputFile(CatalogFileSystem fileSystem, String location) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.outputFile = fileSystem.newOutputFile(location);
    }

    public PositionOutputStream create() {
        try {
            return new CountingPositionOutputStream(this.outputFile.create());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create file: " + this.location(), e);
        }
    }

    public PositionOutputStream createOrOverwrite() {
        return this.create();
    }

    public String location() {
        return this.outputFile.location();
    }

    public InputFile toInputFile() {
        return new CatalogIcebergInputFile(this.fileSystem.newInputFile(this.outputFile.location()));
    }

    public String toString() {
        return this.location();
    }

    private static class CountingPositionOutputStream
    extends PositionOutputStream {
        private final CountingOutputStream stream;

        private CountingPositionOutputStream(OutputStream stream) {
            this.stream = new CountingOutputStream(stream);
        }

        public long getPos() {
            return this.stream.getCount();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

