/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.catalog;

import java.util.Map;
import java.util.UUID;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergLocation;

public record IcebergCatalogDetails(UUID catalogId, String catalogName, String description, UUID fileSystemId, String fileSystemLocation, Map<String, String> properties) {
    public String resolveFileSystemLocationSuffix(String suffix) {
        String location = this.normalizeFileSystemLocation();
        return IcebergLocation.of(location).appendSuffix(suffix).toString();
    }

    public String resolveFileSystemLocationSuffix(String suffix1, String suffix2) {
        String location = this.normalizeFileSystemLocation();
        return IcebergLocation.of(location).appendSuffix(suffix1).appendSuffix(suffix2).toString();
    }

    private String normalizeFileSystemLocation() {
        Object location = this.fileSystemLocation;
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }
}

