/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.inject.Inject;
import io.airlift.slice.SizeOf;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.weakref.jmx.Managed;
import ru.cedrusdata.catalog.config.CatalogCacheConfig;
import ru.cedrusdata.catalog.core.principal.cache.PrincipalServiceCacheEntry;
import ru.cedrusdata.catalog.core.principal.cache.PrincipalServiceCacheKey;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public class PrincipalServiceCache {
    private static final int COLLECTION_ENTRY_INSTANCE_SIZE = SizeOf.instanceSize(AbstractMap.SimpleEntry.class);
    private final Optional<Cache<PrincipalServiceCacheKey, PrincipalServiceCacheEntry>> cache;
    private final Optional<ReadWriteLock> cacheLock;
    private final LongAdder size = new LongAdder();

    @Inject
    public PrincipalServiceCache(CatalogCacheConfig config) {
        Objects.requireNonNull(config);
        this.cache = this.buildCache(config.getCachePrincipalSize().toBytes(), config.getCachePrincipalTtl().toMillis());
        this.cacheLock = this.cache.map(c -> new ReentrantReadWriteLock());
    }

    @SuppressModernizer
    private Optional<Cache<PrincipalServiceCacheKey, PrincipalServiceCacheEntry>> buildCache(long maxSizeBytes, long ttlMillis) {
        if (maxSizeBytes == 0L || ttlMillis == 0L) {
            return Optional.empty();
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumWeight(maxSizeBytes).weigher(PrincipalServiceCache::entryWeight).removalListener(notification -> {
            Verify.verify((notification.getKey() != null ? 1 : 0) != 0);
            Verify.verify((notification.getValue() != null ? 1 : 0) != 0);
            this.addSize(-PrincipalServiceCache.entryWeight((PrincipalServiceCacheKey)notification.getKey(), (PrincipalServiceCacheEntry)notification.getValue()));
        }).recordStats();
        if (ttlMillis > 0L) {
            cacheBuilder.expireAfterWrite(ttlMillis, TimeUnit.MILLISECONDS);
        }
        return Optional.of(cacheBuilder.build());
    }

    public Optional<PrincipalServiceCacheEntry> getByPrincipalName(String principalName) {
        PrincipalServiceCacheKey key = PrincipalServiceCache.principalKey(principalName);
        if (this.cache.isPresent()) {
            return Optional.ofNullable((PrincipalServiceCacheEntry)this.cache.get().getIfPresent((Object)key));
        }
        return Optional.empty();
    }

    public void putPrincipalName(PrincipalServiceCacheEntry entry) {
        if (this.cache.isPresent()) {
            PrincipalServiceCacheKey key = PrincipalServiceCache.principalKey(entry.name());
            try {
                this.cache.get().get((Object)key, () -> entry);
                this.addSize(PrincipalServiceCache.entryWeight(key, entry));
            }
            catch (ExecutionException e) {
                throw new CatalogInternalServerErrorException("Unexpected cache exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Optional<PrincipalServiceCacheEntry> getByAccessTokenId(String accessTokenId, String accessToken) {
        if (this.cache.isPresent()) {
            PrincipalServiceCacheKey key = PrincipalServiceCache.accessTokenIdKey(accessTokenId);
            PrincipalServiceCacheEntry value = (PrincipalServiceCacheEntry)this.cache.get().getIfPresent((Object)key);
            if (value != null && value.accessToken().equals(accessToken)) {
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }

    public void putAccessTokenId(String accessTokenId, PrincipalServiceCacheEntry entry) {
        if (this.cache.isPresent()) {
            PrincipalServiceCacheKey key = PrincipalServiceCache.accessTokenIdKey(accessTokenId);
            try {
                this.cache.get().get((Object)key, () -> entry);
                this.addSize(PrincipalServiceCache.entryWeight(key, entry));
            }
            catch (ExecutionException e) {
                throw new CatalogInternalServerErrorException("Unexpected cache exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void invalidatePrincipalNameAndAccessTokenIds(String principalName, Collection<String> accessTokenIds) {
        if (this.cache.isPresent()) {
            this.cache.get().invalidate((Object)PrincipalServiceCache.principalKey(principalName));
            for (String accessTokenId : accessTokenIds) {
                this.cache.get().invalidate((Object)PrincipalServiceCache.accessTokenIdKey(accessTokenId));
            }
        }
    }

    public void invalidateAccessTokenId(String accessTokenId) {
        if (this.cache.isPresent()) {
            this.cache.get().invalidate((Object)PrincipalServiceCache.accessTokenIdKey(accessTokenId));
        }
    }

    private static PrincipalServiceCacheKey principalKey(String principalName) {
        return new PrincipalServiceCacheKey(principalName, false);
    }

    private static PrincipalServiceCacheKey accessTokenIdKey(String accessTokenId) {
        return new PrincipalServiceCacheKey(accessTokenId, true);
    }

    public void withWriteLock(Runnable task) {
        if (this.cacheLock.isPresent()) {
            this.cacheLock.get().writeLock().lock();
            try {
                task.run();
            }
            finally {
                this.cacheLock.get().writeLock().unlock();
            }
        } else {
            task.run();
        }
    }

    public <T> T withReadLock(Supplier<T> task) {
        if (this.cacheLock.isPresent()) {
            this.cacheLock.get().readLock().lock();
            try {
                T t = task.get();
                return t;
            }
            finally {
                this.cacheLock.get().readLock().unlock();
            }
        }
        return task.get();
    }

    @VisibleForTesting
    public boolean enabled() {
        return this.cache.isPresent();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.map(Cache::stats).map(CacheStats::requestCount).orElse(0L);
    }

    @Managed
    public long getHitCount() {
        return this.cache.map(Cache::stats).map(CacheStats::hitCount).orElse(0L);
    }

    @Managed
    public double getHitRate() {
        return this.cache.map(Cache::stats).map(CacheStats::hitRate).orElse(0.0);
    }

    @Managed
    public long getMissCount() {
        return this.cache.map(Cache::stats).map(CacheStats::missCount).orElse(0L);
    }

    @Managed
    public double getMissRate() {
        return this.cache.map(Cache::stats).map(CacheStats::missRate).orElse(0.0);
    }

    @Managed
    public long getEvictionCount() {
        return this.cache.map(Cache::stats).map(CacheStats::evictionCount).orElse(0L);
    }

    @Managed
    public long getSizeInBytes() {
        return this.size.longValue();
    }

    @Managed
    public long getEntryCount() {
        return this.cache.map(Cache::size).orElse(0L);
    }

    private void addSize(int delta) {
        this.size.add(delta);
    }

    @VisibleForTesting
    public static int entryWeight(PrincipalServiceCacheKey key, PrincipalServiceCacheEntry value) {
        int keySize = key.estimatedSize();
        int valueSize = value.estimatedSize();
        return COLLECTION_ENTRY_INSTANCE_SIZE + keySize + valueSize;
    }
}

