/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.filesystem;

import io.airlift.log.Logger;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemStoppingException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;

public class UsageAwareCatalogFileSystemFactory
implements CatalogFileSystemFactory {
    private static final Logger log = Logger.get(UsageAwareCatalogFileSystemFactory.class);
    private final String fileSystemName;
    private final CatalogFileSystemFactory delegate;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger usageCounter = new AtomicInteger();
    private boolean closeRequested;

    public UsageAwareCatalogFileSystemFactory(String fileSystemName, CatalogFileSystemFactory delegate) {
        this.fileSystemName = fileSystemName;
        this.delegate = delegate;
    }

    public CatalogFileSystem create(String user) {
        return this.delegate.create(user);
    }

    public Optional<String> isLocationValid(String location) {
        return this.delegate.isLocationValid(location);
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void acquire() {
        this.lock.readLock().lock();
        try {
            if (this.closeRequested) {
                throw new CatalogFileSystemStoppingException(this.fileSystemName);
            }
            this.usageCounter.incrementAndGet();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void release() {
        boolean shouldClose = false;
        this.lock.readLock().lock();
        try {
            int val = this.usageCounter.decrementAndGet();
            if (this.closeRequested && val == 0) {
                shouldClose = true;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (shouldClose) {
            this.doClose();
        }
    }

    public void close() {
        boolean shouldClose = false;
        this.lock.writeLock().lock();
        try {
            if (!this.closeRequested) {
                this.closeRequested = true;
                if (this.usageCounter.get() == 0) {
                    shouldClose = true;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (shouldClose) {
            this.doClose();
        }
    }

    private void doClose() {
        try {
            this.delegate.close();
        }
        catch (Throwable e) {
            log.warn(e, String.format("Exception when trying to close the file system \"%s\"", this.fileSystemName));
        }
    }
}

