/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import org.weakref.jmx.guice.ExportBinder;
import ru.cedrusdata.catalog.config.CatalogCacheConfig;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.principal.JwtTokenManager;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.core.principal.cache.PrincipalServiceCache;
import ru.cedrusdata.catalog.core.resource.ResourceModule;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;

public class CoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogCacheConfig.class);
        binder.install((Module)new ResourceModule());
        binder.bind(JwtTokenManager.class).in(Scopes.SINGLETON);
        binder.bind(PrincipalServiceCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PrincipalServiceCache.class).withGeneratedName();
        binder.bind(PrincipalService.class).in(Scopes.SINGLETON);
        binder.bind(FileSystemService.class).in(Scopes.SINGLETON);
        binder.bind(IcebergCatalogService.class).in(Scopes.SINGLETON);
    }
}

