/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.api.JmxEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RoleGrantRequest;
import ru.cedrusdata.catalog.spi.model.RoleRevokeRequest;
import ru.cedrusdata.catalog.spi.model.ServerInfo;
import ru.cedrusdata.catalog.tracing.TracingAttributes;
import ru.cedrusdata.catalog.tracing.TracingScopedSpan;

public class TracingEmbeddedInternalCatalogClient
implements InternalCatalogClient,
InternalIcebergCatalogClient {
    private final AuthenticationContext context;
    private final JmxEmbeddedInternalCatalogClient delegate;
    private final Tracer tracer;

    public TracingEmbeddedInternalCatalogClient(JmxEmbeddedInternalCatalogClient delegate, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.context = delegate.context();
        this.tracer = Objects.requireNonNull(tracer, "tracer");
    }

    public InternalCatalogClient runAs(String subject) {
        Span span = this.startSpan(this.context, ApiType.API, "runAs");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            TracingEmbeddedInternalCatalogClient tracingEmbeddedInternalCatalogClient = new TracingEmbeddedInternalCatalogClient(this.delegate.runAs(subject), this.tracer);
            return tracingEmbeddedInternalCatalogClient;
        }
    }

    public ServerInfo info() {
        Span span = this.startSpan(this.context, ApiType.API, "info");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ServerInfo serverInfo = this.delegate.info();
            return serverInfo;
        }
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createPrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createPrincipal(request);
        }
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updatePrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updatePrincipal(principalName, request);
        }
    }

    public void deletePrincipal(String principalName) {
        Span span = this.startSpan(this.context, ApiType.API, "deletePrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deletePrincipal(principalName);
        }
    }

    public PrincipalInfo getPrincipal(String principalName) {
        Span span = this.startSpan(this.context, ApiType.API, "getPrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrincipalInfo principalInfo = this.delegate.getPrincipal(principalName);
            return principalInfo;
        }
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listPrincipals", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrincipalListResponse principalListResponse = this.delegate.listPrincipals(principalType, page);
            return principalListResponse;
        }
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        Span span = this.startSpan(this.context, ApiType.API, "createTemporaryAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenCreateTemporaryResponse accessTokenCreateTemporaryResponse = this.delegate.createTemporaryAccessToken(subject);
            return accessTokenCreateTemporaryResponse;
        }
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenCreateResponse accessTokenCreateResponse = this.delegate.createAccessToken(request);
            return accessTokenCreateResponse;
        }
    }

    public void deleteAccessToken(String accessTokenId) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteAccessToken(accessTokenId);
        }
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listAccessTokens", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenListResponse accessTokenListResponse = this.delegate.listAccessTokens(principalName, page);
            return accessTokenListResponse;
        }
    }

    public void grantRole(String roleName, RoleGrantRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "grantRole");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.grantRole(roleName, request);
        }
    }

    public void revokeRole(String roleName, RoleRevokeRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "revokeRole");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.revokeRole(roleName, request);
        }
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createFileSystem(request);
        }
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateFileSystem(fileSystemName, request);
        }
    }

    public void deleteFileSystem(String fileSystemName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteFileSystem(fileSystemName);
        }
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        Span span = this.startSpan(this.context, ApiType.API, "getFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemInfo fileSystemInfo = this.delegate.getFileSystem(fileSystemName);
            return fileSystemInfo;
        }
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listFileSystems", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemListResponse fileSystemListResponse = this.delegate.listFileSystems(page);
            return fileSystemListResponse;
        }
    }

    public FileSystemCheckResponse checkFileSystem(FileSystemCheckRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "checkFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemCheckResponse fileSystemCheckResponse = this.delegate.checkFileSystem(request);
            return fileSystemCheckResponse;
        }
    }

    public void createIcebergCatalog(IcebergCatalogCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createIcebergCatalog(request);
        }
    }

    public void updateIcebergCatalog(String catalogName, IcebergCatalogUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateIcebergCatalog(catalogName, request);
        }
    }

    public void deleteIcebergCatalog(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteIcebergCatalog(catalogName);
        }
    }

    public IcebergCatalogInfo getIcebergCatalog(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogInfo icebergCatalogInfo = this.delegate.getIcebergCatalog(catalogName);
            return icebergCatalogInfo;
        }
    }

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergCatalogs", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogListResponse icebergCatalogListResponse = this.delegate.listIcebergCatalogs(page);
            return icebergCatalogListResponse;
        }
    }

    public IcebergNamespaceInfo getIcebergNamespace(String catalogName, String namespaceName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceInfo icebergNamespaceInfo = this.delegate.getIcebergNamespace(catalogName, namespaceName);
            return icebergNamespaceInfo;
        }
    }

    public IcebergNamespaceListResponse listIcebergNamespaces(Optional<String> catalogName, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergNamespaces", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceListResponse icebergNamespaceListResponse = this.delegate.listIcebergNamespaces(catalogName, page);
            return icebergNamespaceListResponse;
        }
    }

    public IcebergObjectInfo getIcebergObject(String catalogName, String namespaceName, String objectName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergObject");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergObjectInfo icebergObjectInfo = this.delegate.getIcebergObject(catalogName, namespaceName, objectName);
            return icebergObjectInfo;
        }
    }

    public IcebergObjectListResponse listIcebergObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergObjects", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergObjectListResponse icebergObjectListResponse = this.delegate.listIcebergObjects(catalogName, namespaceName, objectType, page);
            return icebergObjectListResponse;
        }
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "listMaterializedViewsForRewrite");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergMaterializedViewForRewriteListResponse icebergMaterializedViewForRewriteListResponse = this.delegate.listMaterializedViewsForRewrite(catalogName, request);
            return icebergMaterializedViewForRewriteListResponse;
        }
    }

    @Override
    public ConfigResponse restIcebergGetConfig(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "getConfig");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ConfigResponse configResponse = this.delegate.restIcebergGetConfig(catalogName);
            return configResponse;
        }
    }

    @Override
    public CreateNamespaceResponse restIcebergCreateNamespace(String catalogName, CreateNamespaceRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            CreateNamespaceResponse createNamespaceResponse = this.delegate.restIcebergCreateNamespace(catalogName, request);
            return createNamespaceResponse;
        }
    }

    @Override
    public UpdateNamespacePropertiesResponse restIcebergUpdateNamespaceProperties(String catalogName, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "updateNamespaceProperties");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateNamespacePropertiesResponse updateNamespacePropertiesResponse = this.delegate.restIcebergUpdateNamespaceProperties(catalogName, namespace, request);
            return updateNamespacePropertiesResponse;
        }
    }

    @Override
    public void restIcebergDropNamespace(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropNamespace(catalogName, namespace);
        }
    }

    @Override
    public void restIcebergNamespaceExists(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "namespaceExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergNamespaceExists(catalogName, namespace);
        }
    }

    @Override
    public GetNamespaceResponse restIcebergLoadNamespaceMetadata(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadNamespaceMetadata");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            GetNamespaceResponse getNamespaceResponse = this.delegate.restIcebergLoadNamespaceMetadata(catalogName, namespace);
            return getNamespaceResponse;
        }
    }

    @Override
    public ListNamespacesResponse restIcebergListNamespaces(String catalogName, Optional<Namespace> parentNamespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listNamespaces", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListNamespacesResponse listNamespacesResponse = this.delegate.restIcebergListNamespaces(catalogName, parentNamespace, page);
            return listNamespacesResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergCreateTable(String catalogName, Namespace namespace, CreateTableRequest request, String accessDelegation) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergCreateTable(catalogName, namespace, request, accessDelegation);
            return loadTableResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergRegisterTable(String catalogName, Namespace namespace, RegisterTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "registerTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergRegisterTable(catalogName, namespace, request);
            return loadTableResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergUpdateTable(String catalogName, Namespace namespace, String tableName, UpdateTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "updateTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergUpdateTable(catalogName, namespace, tableName, request);
            return loadTableResponse;
        }
    }

    @Override
    public void restIcebergRenameTable(String catalogName, RenameTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "renameTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergRenameTable(catalogName, request);
        }
    }

    @Override
    public void restIcebergDropTable(String catalogName, Namespace namespace, String tableName, boolean purgeRequested) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropTable");
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.ICEBERG_TABLE_PURGE_REQUESTED, (Object)Boolean.toString(purgeRequested));
        }
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropTable(catalogName, namespace, tableName, purgeRequested);
        }
    }

    @Override
    public LoadTableResponse restIcebergLoadTable(String catalogName, Namespace namespace, String tableName, String snapshots, String accessDelegation) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergLoadTable(catalogName, namespace, tableName, snapshots, accessDelegation);
            return loadTableResponse;
        }
    }

    @Override
    public void restIcebergTableExists(String catalogName, Namespace namespace, String tableName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "tableExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergTableExists(catalogName, namespace, tableName);
        }
    }

    @Override
    public ListTablesResponse restIcebergListTables(String catalogName, Namespace namespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listTables", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListTablesResponse listTablesResponse = this.delegate.restIcebergListTables(catalogName, namespace, page);
            return listTablesResponse;
        }
    }

    @Override
    public LoadViewResponse restIcebergCreateView(String catalogName, Namespace namespace, CreateViewRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergCreateView(catalogName, namespace, request);
            return loadViewResponse;
        }
    }

    @Override
    public LoadViewResponse restIcebergReplaceView(String catalogName, Namespace namespace, String viewName, UpdateTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "replaceView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergReplaceView(catalogName, namespace, viewName, request);
            return loadViewResponse;
        }
    }

    @Override
    public void restIcebergRenameView(String catalogName, RenameTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "renameView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergRenameView(catalogName, request);
        }
    }

    @Override
    public void restIcebergDropView(String catalogName, Namespace namespace, String viewName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropView(catalogName, namespace, viewName);
        }
    }

    @Override
    public LoadViewResponse restIcebergLoadView(String catalogName, Namespace namespace, String viewName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergLoadView(catalogName, namespace, viewName);
            return loadViewResponse;
        }
    }

    @Override
    public void restIcebergViewExists(String catalogName, Namespace namespace, String viewName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "viewExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergViewExists(catalogName, namespace, viewName);
        }
    }

    @Override
    public ListTablesResponse restIcebergListViews(String catalogName, Namespace namespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listViews", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListTablesResponse listTablesResponse = this.delegate.restIcebergListViews(catalogName, namespace, page);
            return listTablesResponse;
        }
    }

    @Override
    public LoadObjectResponse restIcebergLoadObject(String catalogName, Namespace namespace, String objectName, String snapshots, String accessDelegation) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadObject");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadObjectResponse loadObjectResponse = this.delegate.restIcebergLoadObject(catalogName, namespace, objectName, snapshots, accessDelegation);
            return loadObjectResponse;
        }
    }

    private Span startSpan(AuthenticationContext context, ApiType apiType, String methodName) {
        Span span = this.tracer.spanBuilder(apiType.getCaption() + "." + methodName).startSpan();
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.ACTOR, (Object)context.actor().name());
            span.setAttribute(TracingAttributes.SUBJECT, (Object)context.subject().name());
        }
        return span;
    }

    private Span startSpan(AuthenticationContext context, ApiType apiType, String methodName, ResultPage page) {
        Span span = this.startSpan(context, apiType, methodName);
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.RESULT_PAGE_LIMIT, (Object)Integer.toString(page.pageSize().orElse(0)));
        }
        return span;
    }

    private static enum ApiType {
        API("api"),
        ICEBERG_API("iceberg-api");

        private final String caption;

        private ApiType(String caption) {
            this.caption = caption;
        }

        private String getCaption() {
            return this.caption;
        }
    }
}

