/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.api.ApiStats;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.api.IcebergApiStats;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RoleGrantRequest;
import ru.cedrusdata.catalog.spi.model.RoleRevokeRequest;
import ru.cedrusdata.catalog.spi.model.ServerInfo;

public class JmxEmbeddedInternalCatalogClient
implements InternalCatalogClient,
InternalIcebergCatalogClient {
    private final EmbeddedInternalCatalogClient delegate;
    private final ApiStats apiStats;
    private final IcebergApiStats icebergApiStats;

    public JmxEmbeddedInternalCatalogClient(EmbeddedInternalCatalogClient delegate, ApiStats apiStats, IcebergApiStats icebergApiStats) {
        this.delegate = delegate;
        this.apiStats = apiStats;
        this.icebergApiStats = icebergApiStats;
    }

    public AuthenticationContext context() {
        return this.delegate.context();
    }

    public JmxEmbeddedInternalCatalogClient runAs(String subjectPrincipalName) {
        return new JmxEmbeddedInternalCatalogClient(this.delegate.runAs(subjectPrincipalName), this.apiStats, this.icebergApiStats);
    }

    public ServerInfo info() {
        return this.apiStats.getInfo().wrap(this.delegate::info);
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        this.apiStats.getCreatePrincipal().wrap(() -> this.delegate.createPrincipal(request));
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        this.apiStats.getUpdatePrincipal().wrap(() -> this.delegate.updatePrincipal(principalName, request));
    }

    public void deletePrincipal(String principalName) {
        this.apiStats.getDeletePrincipal().wrap(() -> this.delegate.deletePrincipal(principalName));
    }

    public PrincipalInfo getPrincipal(String principalName) {
        return this.apiStats.getGetPrincipal().wrap(() -> this.delegate.getPrincipal(principalName));
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        return this.apiStats.getListPrincipals().wrap(() -> this.delegate.listPrincipals(principalType, page));
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        return this.apiStats.getCreateTemporaryAccessToken().wrap(() -> this.delegate.createTemporaryAccessToken(subject));
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        return this.apiStats.getCreateAccessToken().wrap(() -> this.delegate.createAccessToken(request));
    }

    public void deleteAccessToken(String accessTokenId) {
        this.apiStats.getDeleteAccessToken().wrap(() -> this.delegate.deleteAccessToken(accessTokenId));
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage page) {
        return this.apiStats.getListAccessTokens().wrap(() -> this.delegate.listAccessTokens(principalName, page));
    }

    public void grantRole(String roleName, RoleGrantRequest request) {
        this.apiStats.getGrantRole().wrap(() -> this.delegate.grantRole(roleName, request));
    }

    public void revokeRole(String roleName, RoleRevokeRequest request) {
        this.apiStats.getRevokeRole().wrap(() -> this.delegate.revokeRole(roleName, request));
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        this.apiStats.getCreateFileSystem().wrap(() -> this.delegate.createFileSystem(request));
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        this.apiStats.getUpdateFileSystem().wrap(() -> this.delegate.updateFileSystem(fileSystemName, request));
    }

    public void deleteFileSystem(String fileSystemName) {
        this.apiStats.getDeleteFileSystem().wrap(() -> this.delegate.deleteFileSystem(fileSystemName));
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        return this.apiStats.getGetFileSystem().wrap(() -> this.delegate.getFileSystem(fileSystemName));
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        return this.apiStats.getListFileSystems().wrap(() -> this.delegate.listFileSystems(page));
    }

    public FileSystemCheckResponse checkFileSystem(FileSystemCheckRequest request) {
        return this.apiStats.getCheckFileSystem().wrap(() -> this.delegate.checkFileSystem(request));
    }

    public void createIcebergCatalog(IcebergCatalogCreateRequest request) {
        this.apiStats.getCreateIcebergCatalog().wrap(() -> this.delegate.createIcebergCatalog(request));
    }

    public void updateIcebergCatalog(String catalogName, IcebergCatalogUpdateRequest request) {
        this.apiStats.getUpdateIcebergCatalog().wrap(() -> this.delegate.updateIcebergCatalog(catalogName, request));
    }

    public void deleteIcebergCatalog(String catalogName) {
        this.apiStats.getDeleteIcebergCatalog().wrap(() -> this.delegate.deleteIcebergCatalog(catalogName));
    }

    public IcebergCatalogInfo getIcebergCatalog(String catalogName) {
        return this.apiStats.getGetIcebergCatalog().wrap(() -> this.delegate.getIcebergCatalog(catalogName));
    }

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        return this.apiStats.getListIcebergCatalogs().wrap(() -> this.delegate.listIcebergCatalogs(page));
    }

    public IcebergNamespaceInfo getIcebergNamespace(String catalogName, String namespaceName) {
        return this.apiStats.getGetIcebergNamespace().wrap(() -> this.delegate.getIcebergNamespace(catalogName, namespaceName));
    }

    public IcebergNamespaceListResponse listIcebergNamespaces(Optional<String> catalogName, ResultPage page) {
        return this.apiStats.getListIcebergNamespaces().wrap(() -> this.delegate.listIcebergNamespaces(catalogName, page));
    }

    public IcebergObjectInfo getIcebergObject(String catalogName, String namespaceName, String objectName) {
        return this.apiStats.getGetIcebergObject().wrap(() -> this.delegate.getIcebergObject(catalogName, namespaceName, objectName));
    }

    public IcebergObjectListResponse listIcebergObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        return this.apiStats.getListIcebergObjects().wrap(() -> this.delegate.listIcebergObjects(catalogName, namespaceName, objectType, page));
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        return this.apiStats.getListMaterializedViewsForRewrite().wrap(() -> this.delegate.listMaterializedViewsForRewrite(catalogName, request));
    }

    @Override
    public ConfigResponse restIcebergGetConfig(String catalogName) {
        return this.icebergApiStats.getGetConfig().wrap(() -> this.delegate.restIcebergGetConfig(catalogName));
    }

    @Override
    public CreateNamespaceResponse restIcebergCreateNamespace(String catalogName, CreateNamespaceRequest request) {
        return this.icebergApiStats.getCreateNamespace().wrap(() -> this.delegate.restIcebergCreateNamespace(catalogName, request));
    }

    @Override
    public UpdateNamespacePropertiesResponse restIcebergUpdateNamespaceProperties(String catalogName, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        return this.icebergApiStats.getUpdateNamespaceProperties().wrap(() -> this.delegate.restIcebergUpdateNamespaceProperties(catalogName, namespace, request));
    }

    @Override
    public void restIcebergDropNamespace(String catalogName, Namespace namespace) {
        this.icebergApiStats.getDropNamespace().wrap(() -> this.delegate.restIcebergDropNamespace(catalogName, namespace));
    }

    @Override
    public void restIcebergNamespaceExists(String catalogName, Namespace namespace) {
        this.icebergApiStats.getNamespaceExists().wrap(() -> this.delegate.restIcebergNamespaceExists(catalogName, namespace));
    }

    @Override
    public GetNamespaceResponse restIcebergLoadNamespaceMetadata(String catalogName, Namespace namespace) {
        return this.icebergApiStats.getLoadNamespaceMetadata().wrap(() -> this.delegate.restIcebergLoadNamespaceMetadata(catalogName, namespace));
    }

    @Override
    public ListNamespacesResponse restIcebergListNamespaces(String catalogName, Optional<Namespace> parentNamespace, ResultPage page) {
        return this.icebergApiStats.getListNamespaces().wrap(() -> this.delegate.restIcebergListNamespaces(catalogName, parentNamespace, page));
    }

    @Override
    public LoadTableResponse restIcebergCreateTable(String catalogName, Namespace namespace, CreateTableRequest request, String accessDelegation) {
        return this.icebergApiStats.getCreateTable().wrap(() -> this.delegate.restIcebergCreateTable(catalogName, namespace, request, accessDelegation));
    }

    @Override
    public LoadTableResponse restIcebergRegisterTable(String catalogName, Namespace namespace, RegisterTableRequest request) {
        return this.icebergApiStats.getRegisterTable().wrap(() -> this.delegate.restIcebergRegisterTable(catalogName, namespace, request));
    }

    @Override
    public LoadTableResponse restIcebergUpdateTable(String catalogName, Namespace namespace, String tableName, UpdateTableRequest request) {
        return this.icebergApiStats.getUpdateTable().wrap(() -> this.delegate.restIcebergUpdateTable(catalogName, namespace, tableName, request));
    }

    @Override
    public void restIcebergRenameTable(String catalogName, RenameTableRequest request) {
        this.icebergApiStats.getRenameTable().wrap(() -> this.delegate.restIcebergRenameTable(catalogName, request));
    }

    @Override
    public void restIcebergDropTable(String catalogName, Namespace namespace, String tableName, boolean purgeRequested) {
        this.icebergApiStats.getDropTable().wrap(() -> this.delegate.restIcebergDropTable(catalogName, namespace, tableName, purgeRequested));
    }

    @Override
    public LoadTableResponse restIcebergLoadTable(String catalogName, Namespace namespace, String tableName, String snapshots, String accessDelegation) {
        return this.icebergApiStats.getLoadTable().wrap(() -> this.delegate.restIcebergLoadTable(catalogName, namespace, tableName, snapshots, accessDelegation));
    }

    @Override
    public void restIcebergTableExists(String catalogName, Namespace namespace, String tableName) {
        this.icebergApiStats.getTableExists().wrap(() -> this.delegate.restIcebergTableExists(catalogName, namespace, tableName));
    }

    @Override
    public ListTablesResponse restIcebergListTables(String catalogName, Namespace namespace, ResultPage page) {
        return this.icebergApiStats.getListTables().wrap(() -> this.delegate.restIcebergListTables(catalogName, namespace, page));
    }

    @Override
    public LoadViewResponse restIcebergCreateView(String catalogName, Namespace namespace, CreateViewRequest request) {
        return this.icebergApiStats.getCreateView().wrap(() -> this.delegate.restIcebergCreateView(catalogName, namespace, request));
    }

    @Override
    public LoadViewResponse restIcebergReplaceView(String catalogName, Namespace namespace, String viewName, UpdateTableRequest request) {
        return this.icebergApiStats.getReplaceView().wrap(() -> this.delegate.restIcebergReplaceView(catalogName, namespace, viewName, request));
    }

    @Override
    public void restIcebergRenameView(String catalogName, RenameTableRequest request) {
        this.icebergApiStats.getRenameView().wrap(() -> this.delegate.restIcebergRenameView(catalogName, request));
    }

    @Override
    public void restIcebergDropView(String catalogName, Namespace namespace, String viewName) {
        this.icebergApiStats.getDropView().wrap(() -> this.delegate.restIcebergDropView(catalogName, namespace, viewName));
    }

    @Override
    public LoadViewResponse restIcebergLoadView(String catalogName, Namespace namespace, String viewName) {
        return this.icebergApiStats.getLoadView().wrap(() -> this.delegate.restIcebergLoadView(catalogName, namespace, viewName));
    }

    @Override
    public void restIcebergViewExists(String catalogName, Namespace namespace, String viewName) {
        this.icebergApiStats.getViewExists().wrap(() -> this.delegate.restIcebergViewExists(catalogName, namespace, viewName));
    }

    @Override
    public ListTablesResponse restIcebergListViews(String catalogName, Namespace namespace, ResultPage page) {
        return this.icebergApiStats.getListViews().wrap(() -> this.delegate.restIcebergListViews(catalogName, namespace, page));
    }

    @Override
    public LoadObjectResponse restIcebergLoadObject(String catalogName, Namespace namespace, String objectName, String snapshots, String accessDelegation) {
        return this.icebergApiStats.getLoadObject().wrap(() -> this.delegate.restIcebergLoadObject(catalogName, namespace, objectName, snapshots, accessDelegation));
    }
}

