/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import java.util.Objects;
import java.util.Optional;
import ru.cedrusdata.catalog.api.ApiStats;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.api.IcebergApiStats;
import ru.cedrusdata.catalog.api.JmxEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.api.TracingEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.tracing.TracingProvider;

public class EmbeddedInternalCatalogClientFactory {
    private final ServerVersion serverVersion;
    private final ServerInitializationInfo serverInitializationInfo;
    private final PrincipalService principalService;
    private final FileSystemService fileSystemService;
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergNamespaceService icebergNamespaceService;
    private final IcebergTableService icebergTableService;
    private final ApiStats apiStats;
    private final IcebergApiStats icebergApiStats;
    private final Optional<Tracer> tracer;

    @Inject
    public EmbeddedInternalCatalogClientFactory(ServerVersion serverVersion, ServerInitializationInfo serverInitializationInfo, PrincipalService principalService, FileSystemService fileSystemService, IcebergCatalogService icebergCatalogService, IcebergNamespaceService icebergNamespaceService, IcebergTableService icebergTableService, ApiStats apiStats, IcebergApiStats icebergApiStats, TracingProvider tracingProvider) {
        this.serverVersion = Objects.requireNonNull(serverVersion, "serverVersion");
        this.serverInitializationInfo = Objects.requireNonNull(serverInitializationInfo, "serverInitializationInfo");
        this.principalService = Objects.requireNonNull(principalService, "userService");
        this.fileSystemService = Objects.requireNonNull(fileSystemService, "fileSystemService");
        this.icebergCatalogService = Objects.requireNonNull(icebergCatalogService, "icebergCatalogService");
        this.icebergNamespaceService = Objects.requireNonNull(icebergNamespaceService, "icebergNamespaceService");
        this.icebergTableService = Objects.requireNonNull(icebergTableService, "icebergTableService");
        this.apiStats = Objects.requireNonNull(apiStats, "apiStats");
        this.icebergApiStats = Objects.requireNonNull(icebergApiStats, "icebergApiStats");
        this.tracer = Objects.requireNonNull(tracingProvider, "tracingProvider").tracerForApi();
    }

    public InternalCatalogClient createClient(AuthenticationContext context) {
        JmxEmbeddedInternalCatalogClient client = this.createJmxClient(context);
        return this.tracer.isPresent() ? new TracingEmbeddedInternalCatalogClient(client, this.tracer.get()) : client;
    }

    public InternalIcebergCatalogClient createIcebergClient(AuthenticationContext context) {
        JmxEmbeddedInternalCatalogClient client = this.createJmxClient(context);
        return this.tracer.isPresent() ? new TracingEmbeddedInternalCatalogClient(client, this.tracer.get()) : client;
    }

    @VisibleForTesting
    public JmxEmbeddedInternalCatalogClient createJmxClient(AuthenticationContext context) {
        return new JmxEmbeddedInternalCatalogClient(this.createEmbeddedClient(context), this.apiStats, this.icebergApiStats);
    }

    @VisibleForTesting
    public EmbeddedInternalCatalogClient createEmbeddedClient(AuthenticationContext context) {
        return new EmbeddedInternalCatalogClient(context, this.serverVersion, this.serverInitializationInfo, this.principalService, this.fileSystemService, this.icebergCatalogService, this.icebergNamespaceService, this.icebergTableService);
    }
}

