/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceListResult;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespacePropertiesUpdateResult;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthorizationException;
import ru.cedrusdata.catalog.spi.exception.CatalogUnsupportedOperationException;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RoleGrantRequest;
import ru.cedrusdata.catalog.spi.model.RoleRevokeRequest;
import ru.cedrusdata.catalog.spi.model.ServerInfo;
import ru.cedrusdata.catalog.spi.security.CatalogPrivilege;

public class EmbeddedInternalCatalogClient
implements InternalCatalogClient,
InternalIcebergCatalogClient {
    private final AuthenticationContext context;
    private final ServerVersion serverVersion;
    private final ServerInitializationInfo serverInitializationInfo;
    private final PrincipalService principalService;
    private final FileSystemService fileSystemService;
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergNamespaceService icebergNamespaceService;
    private final IcebergTableService icebergTableService;

    public EmbeddedInternalCatalogClient(AuthenticationContext context, ServerVersion serverVersion, ServerInitializationInfo serverInitializationInfo, PrincipalService principalService, FileSystemService fileSystemService, IcebergCatalogService icebergCatalogService, IcebergNamespaceService icebergNamespaceService, IcebergTableService icebergTableService) {
        this.context = context;
        this.serverVersion = serverVersion;
        this.serverInitializationInfo = serverInitializationInfo;
        this.principalService = principalService;
        this.fileSystemService = fileSystemService;
        this.icebergCatalogService = icebergCatalogService;
        this.icebergNamespaceService = icebergNamespaceService;
        this.icebergTableService = icebergTableService;
    }

    public AuthenticationContext context() {
        return this.context;
    }

    public EmbeddedInternalCatalogClient runAs(String subjectPrincipalName) {
        AuthenticationContext impersonatedContext = this.principalService.impersonate(this.context, subjectPrincipalName);
        return new EmbeddedInternalCatalogClient(impersonatedContext, this.serverVersion, this.serverInitializationInfo, this.principalService, this.fileSystemService, this.icebergCatalogService, this.icebergNamespaceService, this.icebergTableService);
    }

    public ServerInfo info() {
        return new ServerInfo(this.serverVersion.getVersion(), Boolean.valueOf(this.serverInitializationInfo.isInitialized()));
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        this.principalService.createPrincipal(this.context.subject(), request);
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        this.principalService.updatePrincipal(this.context.subject(), principalName, request);
    }

    public void deletePrincipal(String principalName) {
        this.principalService.deletePrincipal(this.context.subject(), principalName);
    }

    public PrincipalInfo getPrincipal(String principalName) {
        return this.principalService.getPrincipal(this.context.subject(), principalName);
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        return this.principalService.listPrincipals(this.context.subject(), principalType, page);
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        return this.principalService.createTemporaryAccessToken(this.context, subject);
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        return this.principalService.createAccessToken(this.context.subject(), request);
    }

    public void deleteAccessToken(String accessTokenId) {
        this.principalService.deleteAccessToken(this.context.subject(), accessTokenId);
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage page) {
        return this.principalService.listAccessTokens(this.context.subject(), principalName, page);
    }

    public void grantRole(String roleName, RoleGrantRequest request) {
        this.principalService.grantRole(this.context.subject(), roleName, request);
    }

    public void revokeRole(String roleName, RoleRevokeRequest request) {
        this.principalService.revokeRole(this.context.subject(), roleName, request);
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        this.fileSystemService.createFileSystem(this.context.subject(), request);
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        this.fileSystemService.updateFileSystem(this.context.subject(), fileSystemName, request);
    }

    public void deleteFileSystem(String fileSystemName) {
        this.fileSystemService.deleteFileSystem(this.context.subject(), fileSystemName);
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        return this.fileSystemService.getFileSystem(this.context.subject(), fileSystemName);
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        return this.fileSystemService.listFileSystems(this.context.subject(), page);
    }

    public FileSystemCheckResponse checkFileSystem(FileSystemCheckRequest request) {
        return this.fileSystemService.check(this.context.subject(), request.getFileSystemName(), request.getLocation());
    }

    public void createIcebergCatalog(IcebergCatalogCreateRequest request) {
        if (!this.context.subject().admin() && !this.context.subject().icebergAdmin()) {
            throw new CatalogAuthorizationException(CatalogPrivilege.ICEBERG_CATALOG_CREATE);
        }
        this.icebergCatalogService.createIcebergCatalog(request);
    }

    public void updateIcebergCatalog(String catalogName, IcebergCatalogUpdateRequest request) {
        if (!this.context.subject().admin() && !this.context.subject().icebergAdmin()) {
            throw new CatalogAuthorizationException(CatalogPrivilege.ICEBERG_CATALOG_UPDATE);
        }
        this.icebergCatalogService.updateIcebergCatalog(catalogName, request);
    }

    public void deleteIcebergCatalog(String catalogName) {
        if (!this.context.subject().admin() && !this.context.subject().icebergAdmin()) {
            throw new CatalogAuthorizationException(CatalogPrivilege.ICEBERG_CATALOG_DELETE);
        }
        this.icebergCatalogService.deleteIcebergCatalog(catalogName);
    }

    public IcebergCatalogInfo getIcebergCatalog(String catalogName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_CATALOG_GET);
        return this.icebergCatalogService.getIcebergCatalog(catalogName);
    }

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        if (!this.context.subject().admin() && !this.context.subject().icebergAdmin()) {
            throw new CatalogAuthorizationException(CatalogPrivilege.ICEBERG_CATALOG_LIST);
        }
        return this.icebergCatalogService.listIcebergCatalogs(page);
    }

    public IcebergNamespaceInfo getIcebergNamespace(String catalogName, String namespaceName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_GET);
        IcebergNamespaceDetails details = this.icebergNamespaceService.getNamespace(this.context.subject(), catalogName, namespaceName);
        return new IcebergNamespaceInfo(CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_CATALOG, catalogName), details.namespaceName(), details.properties());
    }

    public IcebergNamespaceListResponse listIcebergNamespaces(Optional<String> catalogName, ResultPage page) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_LIST);
        return this.icebergNamespaceService.listNamespacesForApi(catalogName, page);
    }

    public IcebergObjectInfo getIcebergObject(String catalogName, String namespaceName, String objectName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        return this.icebergTableService.getObjectForApi(catalogName, namespaceName, objectName);
    }

    public IcebergObjectListResponse listIcebergObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_LIST);
        return this.icebergTableService.listObjectsForApi(catalogName, namespaceName, objectType, page);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_LIST);
        return this.icebergTableService.listMaterializedViewsForRewrite(catalogName, request.getTableNames());
    }

    @Override
    public ConfigResponse restIcebergGetConfig(String catalogName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_CATALOG_GET);
        return this.icebergCatalogService.execute(this.context.subject(), catalogName, catalogContext -> {
            IcebergCatalogDetails icebergCatalogDetails = catalogContext.catalogInfo();
            HashMap<String, String> defaults = new HashMap<String, String>();
            if (icebergCatalogDetails.properties() != null) {
                defaults.putAll(icebergCatalogDetails.properties());
            }
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("rest-metrics-reporting-enabled", Boolean.FALSE.toString());
            overrides.put("prefix", icebergCatalogDetails.catalogName());
            overrides.put("location", icebergCatalogDetails.fileSystemLocation());
            overrides.put("view-endpoints-supported", "true");
            return ConfigResponse.builder().withDefaults(defaults).withOverrides(overrides).build();
        });
    }

    @Override
    public CreateNamespaceResponse restIcebergCreateNamespace(String catalogName, CreateNamespaceRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_CREATE);
        IcebergNamespaceDetails namespaceInfo = this.icebergNamespaceService.createNamespace(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(request.namespace()), request.properties());
        return CreateNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{namespaceInfo.namespaceName()})).setProperties(namespaceInfo.properties()).build();
    }

    @Override
    public UpdateNamespacePropertiesResponse restIcebergUpdateNamespaceProperties(String catalogName, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_UPDATE);
        IcebergNamespacePropertiesUpdateResult result = this.icebergNamespaceService.updateNamespaceProperties(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request.updates(), request.removals());
        HashSet missing = new HashSet(request.removals());
        missing.removeAll(result.removed());
        return UpdateNamespacePropertiesResponse.builder().addUpdated(result.updated()).addRemoved(result.removed()).addMissing(missing).build();
    }

    @Override
    public void restIcebergDropNamespace(String catalogName, Namespace namespace) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_DELETE);
        this.icebergNamespaceService.deleteNamespace(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
    }

    @Override
    public void restIcebergNamespaceExists(String catalogName, Namespace namespace) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_GET);
        this.icebergNamespaceService.getNamespace(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
    }

    @Override
    public GetNamespaceResponse restIcebergLoadNamespaceMetadata(String catalogName, Namespace namespace) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_GET);
        IcebergNamespaceDetails info = this.icebergNamespaceService.getNamespace(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
        return GetNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{info.namespaceName()})).setProperties(info.properties()).build();
    }

    @Override
    public ListNamespacesResponse restIcebergListNamespaces(String catalogName, Optional<Namespace> parentNamespace, ResultPage page) {
        IcebergNamespaceListResult result;
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_NAMESPACE_LIST);
        if (parentNamespace.isPresent()) {
            this.icebergNamespaceService.getNamespace(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(parentNamespace.get()));
            result = new IcebergNamespaceListResult(List.of(), null);
        } else {
            result = this.icebergNamespaceService.listNamespaces(this.context.subject(), catalogName, page);
        }
        ListNamespacesResponse.Builder builder = ListNamespacesResponse.builder();
        for (String namespaceName : result.namespaces()) {
            builder.add(Namespace.of((String[])new String[]{namespaceName}));
        }
        builder.nextPageToken(result.token());
        return builder.build();
    }

    @Override
    public LoadTableResponse restIcebergCreateTable(String catalogName, Namespace namespace, CreateTableRequest request, String accessDelegation) {
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_CREATE);
        return this.icebergTableService.createTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request);
    }

    @Override
    public LoadTableResponse restIcebergRegisterTable(String catalogName, Namespace namespace, RegisterTableRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_REGISTER);
        return this.icebergTableService.registerTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request);
    }

    @Override
    public LoadTableResponse restIcebergUpdateTable(String catalogName, Namespace namespace, String tableName, UpdateTableRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_UPDATE);
        return this.icebergTableService.updateTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName, request);
    }

    @Override
    public void restIcebergRenameTable(String catalogName, RenameTableRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_UPDATE);
        this.icebergTableService.renameTable(this.context.subject(), catalogName, request);
    }

    @Override
    public void restIcebergDropTable(String catalogName, Namespace namespace, String tableName, boolean purgeRequested) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_DELETE);
        this.icebergTableService.dropTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName, purgeRequested);
    }

    @Override
    public LoadTableResponse restIcebergLoadTable(String catalogName, Namespace namespace, String tableName, String snapshots, String accessDelegation) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        return this.icebergTableService.loadTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName);
    }

    @Override
    public void restIcebergTableExists(String catalogName, Namespace namespace, String tableName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        this.icebergTableService.tableExists(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName);
    }

    @Override
    public ListTablesResponse restIcebergListTables(String catalogName, Namespace namespace, ResultPage page) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_LIST);
        return this.icebergTableService.listTables(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), page);
    }

    @Override
    public LoadViewResponse restIcebergCreateView(String catalogName, Namespace namespace, CreateViewRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_CREATE);
        return this.icebergTableService.createView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request);
    }

    @Override
    public LoadViewResponse restIcebergReplaceView(String catalogName, Namespace namespace, String viewName, UpdateTableRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_UPDATE);
        return this.icebergTableService.updateView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName, request);
    }

    @Override
    public void restIcebergRenameView(String catalogName, RenameTableRequest request) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_UPDATE);
        this.icebergTableService.renameView(this.context.subject(), catalogName, request);
    }

    @Override
    public void restIcebergDropView(String catalogName, Namespace namespace, String viewName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_DELETE);
        this.icebergTableService.dropView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName);
    }

    @Override
    public LoadViewResponse restIcebergLoadView(String catalogName, Namespace namespace, String viewName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        return this.icebergTableService.loadView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName);
    }

    @Override
    public void restIcebergViewExists(String catalogName, Namespace namespace, String viewName) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        this.icebergTableService.viewExists(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName);
    }

    @Override
    public ListTablesResponse restIcebergListViews(String catalogName, Namespace namespace, ResultPage page) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_LIST);
        return this.icebergTableService.listViews(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), page);
    }

    @Override
    public LoadObjectResponse restIcebergLoadObject(String catalogName, Namespace namespace, String objectName, String snapshots, String accessDelegation) {
        this.checkIcebergCatalogAdmin(CatalogPrivilege.ICEBERG_TABLE_GET);
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        return this.icebergTableService.loadObject(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), objectName);
    }

    private void checkIcebergCatalogAdmin(CatalogPrivilege privilege) {
        if (!this.context.subject().admin() && !this.context.subject().icebergAdmin()) {
            throw new CatalogAuthorizationException(privilege);
        }
    }
}

