/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.GenericJson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.OAuth2Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class CredentialAccessBoundary {
    private static final int RULES_SIZE_LIMIT = 10;
    private final List<AccessBoundaryRule> accessBoundaryRules;

    CredentialAccessBoundary(List<AccessBoundaryRule> accessBoundaryRules) {
        Preconditions.checkNotNull(accessBoundaryRules);
        Preconditions.checkArgument(!accessBoundaryRules.isEmpty(), "At least one access boundary rule must be provided.");
        Preconditions.checkArgument(accessBoundaryRules.size() < 10, String.format("The provided list has more than %s access boundary rules.", 10));
        this.accessBoundaryRules = accessBoundaryRules;
    }

    String toJson() {
        ArrayList<GenericJson> rules = new ArrayList<GenericJson>();
        for (AccessBoundaryRule rule : this.accessBoundaryRules) {
            GenericJson ruleJson = new GenericJson();
            ruleJson.setFactory(OAuth2Utils.JSON_FACTORY);
            ruleJson.put("availableResource", (Object)rule.getAvailableResource());
            ruleJson.put("availablePermissions", (Object)rule.getAvailablePermissions());
            AccessBoundaryRule.AvailabilityCondition availabilityCondition = rule.getAvailabilityCondition();
            if (availabilityCondition != null) {
                GenericJson availabilityConditionJson = new GenericJson();
                availabilityConditionJson.setFactory(OAuth2Utils.JSON_FACTORY);
                availabilityConditionJson.put("expression", (Object)availabilityCondition.getExpression());
                if (availabilityCondition.getTitle() != null) {
                    availabilityConditionJson.put("title", (Object)availabilityCondition.getTitle());
                }
                if (availabilityCondition.getDescription() != null) {
                    availabilityConditionJson.put("description", (Object)availabilityCondition.getDescription());
                }
                ruleJson.put("availabilityCondition", (Object)availabilityConditionJson);
            }
            rules.add(ruleJson);
        }
        GenericJson accessBoundaryRulesJson = new GenericJson();
        accessBoundaryRulesJson.setFactory(OAuth2Utils.JSON_FACTORY);
        accessBoundaryRulesJson.put("accessBoundaryRules", (Object)rules);
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("accessBoundary", (Object)accessBoundaryRulesJson);
        return json.toString();
    }

    public List<AccessBoundaryRule> getAccessBoundaryRules() {
        return this.accessBoundaryRules;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class AccessBoundaryRule {
        private final String availableResource;
        private final List<String> availablePermissions;
        @Nullable
        private final AvailabilityCondition availabilityCondition;

        AccessBoundaryRule(String availableResource, List<String> availablePermissions, @Nullable AvailabilityCondition availabilityCondition) {
            this.availableResource = Preconditions.checkNotNull(availableResource);
            this.availablePermissions = new ArrayList<String>((Collection)Preconditions.checkNotNull(availablePermissions));
            this.availabilityCondition = availabilityCondition;
            Preconditions.checkArgument(!availableResource.isEmpty(), "The provided availableResource is empty.");
            Preconditions.checkArgument(!availablePermissions.isEmpty(), "The list of provided availablePermissions is empty.");
            for (String permission : availablePermissions) {
                if (permission == null) {
                    throw new IllegalArgumentException("One of the provided available permissions is null.");
                }
                if (!permission.isEmpty()) continue;
                throw new IllegalArgumentException("One of the provided available permissions is empty.");
            }
        }

        public String getAvailableResource() {
            return this.availableResource;
        }

        public List<String> getAvailablePermissions() {
            return this.availablePermissions;
        }

        @Nullable
        public AvailabilityCondition getAvailabilityCondition() {
            return this.availabilityCondition;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class AvailabilityCondition {
            private final String expression;
            @Nullable
            private final String title;
            @Nullable
            private final String description;

            AvailabilityCondition(String expression, @Nullable String title, @Nullable String description) {
                this.expression = Preconditions.checkNotNull(expression);
                this.title = title;
                this.description = description;
                Preconditions.checkArgument(!expression.isEmpty(), "The provided expression is empty.");
            }

            public String getExpression() {
                return this.expression;
            }

            @Nullable
            public String getTitle() {
                return this.title;
            }

            @Nullable
            public String getDescription() {
                return this.description;
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public static final class Builder {
                private String expression;
                @Nullable
                private String title;
                @Nullable
                private String description;

                private Builder() {
                }

                @CanIgnoreReturnValue
                public Builder setExpression(String expression) {
                    this.expression = expression;
                    return this;
                }

                @CanIgnoreReturnValue
                public Builder setTitle(String title) {
                    this.title = title;
                    return this;
                }

                @CanIgnoreReturnValue
                public Builder setDescription(String description) {
                    this.description = description;
                    return this;
                }

                public AvailabilityCondition build() {
                    return new AvailabilityCondition(this.expression, this.title, this.description);
                }
            }
        }

        public static class Builder {
            private String availableResource;
            private List<String> availablePermissions;
            @Nullable
            private AvailabilityCondition availabilityCondition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public Builder setAvailableResource(String availableResource) {
                this.availableResource = availableResource;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAvailablePermissions(List<String> availablePermissions) {
                this.availablePermissions = new ArrayList<String>((Collection)Preconditions.checkNotNull(availablePermissions));
                return this;
            }

            public Builder addAvailablePermission(String availablePermission) {
                if (this.availablePermissions == null) {
                    this.availablePermissions = new ArrayList<String>();
                }
                this.availablePermissions.add(availablePermission);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAvailabilityCondition(AvailabilityCondition availabilityCondition) {
                this.availabilityCondition = availabilityCondition;
                return this;
            }

            public AccessBoundaryRule build() {
                return new AccessBoundaryRule(this.availableResource, this.availablePermissions, this.availabilityCondition);
            }
        }
    }

    public static class Builder {
        private List<AccessBoundaryRule> accessBoundaryRules;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setRules(List<AccessBoundaryRule> rule) {
            this.accessBoundaryRules = new ArrayList<AccessBoundaryRule>((Collection)Preconditions.checkNotNull(rule));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addRule(AccessBoundaryRule rule) {
            if (this.accessBoundaryRules == null) {
                this.accessBoundaryRules = new ArrayList<AccessBoundaryRule>();
            }
            this.accessBoundaryRules.add(Preconditions.checkNotNull(rule));
            return this;
        }

        public CredentialAccessBoundary build() {
            return new CredentialAccessBoundary(this.accessBoundaryRules);
        }
    }
}

