/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.List;
import java.util.UUID;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.TelemetryPlugin;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywayTelemetryManager
implements AutoCloseable {
    private PluginRegister pluginRegister;
    private RootTelemetryModel rootTelemetryModel = new RootTelemetryModel();

    public FlywayTelemetryManager(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
        List<TelemetryPlugin> telemetryPlugins = pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.logRootDetails(this.rootTelemetryModel);
        }
        String userId = System.getenv("RG_TELEMETRY_ANONYMOUS_USER_ID");
        if (!StringUtils.hasText(userId)) {
            userId = FileUtils.readUserIdFromFileIfNoneWriteDefault();
        }
        this.rootTelemetryModel.setUserId(userId);
        String sessionId = System.getenv("RG_TELEMETRY_SESSION_ID");
        if (!StringUtils.hasText(sessionId)) {
            sessionId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setSessionId(sessionId);
        String operationId = System.getenv("RG_TELEMETRY_OPERATION_ID");
        if (!StringUtils.hasText(operationId)) {
            operationId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setOperationId(operationId);
    }

    public void logEvent(EventTelemetryModel model) {
        List<TelemetryPlugin> telemetryPlugins = this.pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.logEventDetails(model);
        }
    }

    @Override
    public void close() throws Exception {
        List<TelemetryPlugin> telemetryPlugins = this.pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.close();
        }
    }

    public RootTelemetryModel getRootTelemetryModel() {
        return this.rootTelemetryModel;
    }

    public void setRootTelemetryModel(RootTelemetryModel rootTelemetryModel) {
        this.rootTelemetryModel = rootTelemetryModel;
    }
}

