/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.hashing;

import java.nio.ByteOrder;
import net.openhft.hashing.Access;
import net.openhft.hashing.LongHashFunction;
import net.openhft.hashing.Primitives;

class WyHash {
    private static final WyHash INSTANCE = new WyHash();
    private static final WyHash NATIVE_WY = LongHashFunction.NATIVE_LITTLE_ENDIAN ? INSTANCE : BigEndian.access$000();
    public static final long _wyp0 = -6884282663029611473L;
    public static final long _wyp1 = -1800455987208640293L;
    public static final long _wyp2 = -8161530843051276573L;
    public static final long _wyp3 = 6384245875588680899L;
    public static final long _wyp4 = 2129725606500045391L;

    private static long _wymum(long lhs, long rhs) {
        long lo_lo = (lhs & 0xFFFFFFFFL) * (rhs & 0xFFFFFFFFL);
        long hi_lo = (lhs >>> 32) * (rhs & 0xFFFFFFFFL);
        long lo_hi = (lhs & 0xFFFFFFFFL) * (rhs >>> 32);
        long hi_hi = (lhs >>> 32) * (rhs >>> 32);
        long cross = (lo_lo >>> 32) + (hi_lo & 0xFFFFFFFFL) + lo_hi;
        long upper = (hi_lo >>> 32) + (cross >>> 32) + hi_hi;
        long lower = cross << 32 | lo_lo & 0xFFFFFFFFL;
        return lower ^ upper;
    }

    <T> long _wyr8(Access<T> access, T in, long index) {
        return access.getLong(in, index);
    }

    <T> long _wyr4(Access<T> access, T in, long index) {
        return access.getUnsignedInt(in, index);
    }

    private <T> long _wyr3(Access<T> access, T in, long index, long k) {
        return (long)access.getUnsignedByte(in, index) << 16 | (long)access.getUnsignedByte(in, index + (k >>> 1)) << 8 | (long)access.getUnsignedByte(in, index + k - 1L);
    }

    private <T> long __wyr8(Access<T> access, T in, long index) {
        return this._wyr4(access, in, index) << 32 | this._wyr4(access, in, index + 4L);
    }

    private WyHash() {
    }

    long toLittleEndian(long v) {
        return v;
    }

    int toLittleEndian(int v) {
        return v;
    }

    short toLittleEndian(short v) {
        return v;
    }

    <T> long wyHash64(long seed, T input, Access<T> access, long off, long length) {
        if (length <= 0L) {
            return 0L;
        }
        if (length < 4L) {
            return WyHash._wymum(WyHash._wymum(this._wyr3(access, input, off, length) ^ seed ^ 0xA0761D6478BD642FL, seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 8L) {
            return WyHash._wymum(WyHash._wymum(this._wyr4(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, this._wyr4(access, input, off + length - 4L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 16L) {
            return WyHash._wymum(WyHash._wymum(this.__wyr8(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, off + length - 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 24L) {
            return WyHash._wymum(WyHash._wymum(this.__wyr8(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, off + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this.__wyr8(access, input, off + length - 8L) ^ seed ^ 0x8EBC6AF09C88C6E3L, seed ^ 0x589965CC75374CC3L), length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 32L) {
            return WyHash._wymum(WyHash._wymum(this.__wyr8(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, off + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this.__wyr8(access, input, off + 16L) ^ seed ^ 0x8EBC6AF09C88C6E3L, this.__wyr8(access, input, off + length - 8L) ^ seed ^ 0x589965CC75374CC3L), length ^ 0x1D8E4E27C47D124FL);
        }
        long see1 = seed;
        long i = length;
        long p = off;
        while (i > 256L) {
            seed = WyHash._wymum(this._wyr8(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this._wyr8(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this._wyr8(access, input, p + 16L) ^ seed ^ 0x8EBC6AF09C88C6E3L, this._wyr8(access, input, p + 24L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(this._wyr8(access, input, p + 32L) ^ see1 ^ 0xE7037ED1A0B428DBL, this._wyr8(access, input, p + 40L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(this._wyr8(access, input, p + 48L) ^ see1 ^ 0x589965CC75374CC3L, this._wyr8(access, input, p + 56L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(this._wyr8(access, input, p + 64L) ^ seed ^ 0xA0761D6478BD642FL, this._wyr8(access, input, p + 72L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this._wyr8(access, input, p + 80L) ^ seed ^ 0x8EBC6AF09C88C6E3L, this._wyr8(access, input, p + 88L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(this._wyr8(access, input, p + 96L) ^ see1 ^ 0xE7037ED1A0B428DBL, this._wyr8(access, input, p + 104L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(this._wyr8(access, input, p + 112L) ^ see1 ^ 0x589965CC75374CC3L, this._wyr8(access, input, p + 120L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(this._wyr8(access, input, p + 128L) ^ seed ^ 0xA0761D6478BD642FL, this._wyr8(access, input, p + 136L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this._wyr8(access, input, p + 144L) ^ seed ^ 0x8EBC6AF09C88C6E3L, this._wyr8(access, input, p + 152L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(this._wyr8(access, input, p + 160L) ^ see1 ^ 0xE7037ED1A0B428DBL, this._wyr8(access, input, p + 168L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(this._wyr8(access, input, p + 176L) ^ see1 ^ 0x589965CC75374CC3L, this._wyr8(access, input, p + 184L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(this._wyr8(access, input, p + 192L) ^ seed ^ 0xA0761D6478BD642FL, this._wyr8(access, input, p + 200L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(this._wyr8(access, input, p + 208L) ^ seed ^ 0x8EBC6AF09C88C6E3L, this._wyr8(access, input, p + 216L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(this._wyr8(access, input, p + 224L) ^ see1 ^ 0xE7037ED1A0B428DBL, this._wyr8(access, input, p + 232L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(this._wyr8(access, input, p + 240L) ^ see1 ^ 0x589965CC75374CC3L, this._wyr8(access, input, p + 248L) ^ see1 ^ 0xA0761D6478BD642FL);
            i -= 256L;
            p += 256L;
        }
        while (i > 32L) {
            seed = WyHash._wymum(this._wyr8(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this._wyr8(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(this._wyr8(access, input, p + 16L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, this._wyr8(access, input, p + 24L) ^ see1 ^ 0x589965CC75374CC3L);
            i -= 32L;
            p += 32L;
        }
        if (i < 4L) {
            seed = WyHash._wymum(this._wyr3(access, input, p, i) ^ seed ^ 0xA0761D6478BD642FL, seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 8L) {
            seed = WyHash._wymum(this._wyr4(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this._wyr4(access, input, p + i - 4L) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 16L) {
            seed = WyHash._wymum(this.__wyr8(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, p + i - 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 24L) {
            seed = WyHash._wymum(this.__wyr8(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(this.__wyr8(access, input, p + i - 8L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, see1 ^ 0x589965CC75374CC3L);
        } else {
            seed = WyHash._wymum(this.__wyr8(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, this.__wyr8(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(this.__wyr8(access, input, p + 16L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, this.__wyr8(access, input, p + i - 8L) ^ see1 ^ 0x589965CC75374CC3L);
        }
        return WyHash._wymum(seed ^ see1, length ^ 0x1D8E4E27C47D124FL);
    }

    static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.SEEDLESS_INSTANCE;
    }

    static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(seed);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private final long seed;

        private AsLongHashFunctionSeeded(long seed) {
            this.seed = seed;
        }

        @Override
        public long seed() {
            return this.seed;
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        private static final long serialVersionUID = 0L;
        static final AsLongHashFunction SEEDLESS_INSTANCE = new AsLongHashFunction();

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return SEEDLESS_INSTANCE;
        }

        public long seed() {
            return 0L;
        }

        @Override
        public long hashLong(long input) {
            input = NATIVE_WY.toLittleEndian(input);
            long hi = input & 0xFFFFFFFFL;
            long lo = input >>> 32 & 0xFFFFFFFFL;
            return WyHash._wymum(WyHash._wymum(hi ^ this.seed() ^ 0xA0761D6478BD642FL, lo ^ this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045383L);
        }

        @Override
        public long hashInt(int input) {
            input = NATIVE_WY.toLittleEndian(input);
            long longInput = (long)input & 0xFFFFFFFFL;
            return WyHash._wymum(WyHash._wymum(longInput ^ this.seed() ^ 0xA0761D6478BD642FL, longInput ^ this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045387L);
        }

        @Override
        public long hashShort(short input) {
            input = NATIVE_WY.toLittleEndian(input);
            long hi = (long)(input >>> 8) & 0xFFL;
            long wyr3 = hi | hi << 8 | ((long)input & 0xFFL) << 16;
            return WyHash._wymum(WyHash._wymum(wyr3 ^ this.seed() ^ 0xA0761D6478BD642FL, this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045389L);
        }

        @Override
        public long hashChar(char input) {
            return this.hashShort((short)input);
        }

        @Override
        public long hashByte(byte input) {
            long hi = (long)input & 0xFFL;
            long wyr3 = hi | hi << 8 | hi << 16;
            return WyHash._wymum(WyHash._wymum(wyr3 ^ this.seed() ^ 0xA0761D6478BD642FL, this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045390L);
        }

        @Override
        public long hashVoid() {
            return 0L;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            long seed = this.seed();
            if (access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
                return INSTANCE.wyHash64(seed, input, access, off, len);
            }
            return BigEndian.INSTANCE.wyHash64(seed, input, access, off, len);
        }
    }

    private static class BigEndian
    extends WyHash {
        private static final BigEndian INSTANCE = new BigEndian();

        private BigEndian() {
        }

        @Override
        <T> long _wyr8(Access<T> access, T in, long off) {
            return Long.reverseBytes(super._wyr8(access, in, off));
        }

        @Override
        <T> long _wyr4(Access<T> access, T in, long off) {
            return Primitives.unsignedInt(Integer.reverseBytes(access.getInt(in, off)));
        }

        @Override
        long toLittleEndian(long v) {
            return Long.reverseBytes(v);
        }

        @Override
        int toLittleEndian(int v) {
            return Integer.reverseBytes(v);
        }

        @Override
        short toLittleEndian(short v) {
            return Short.reverseBytes(v);
        }
    }
}

