/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.CheckSumTypeHandler;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractCheckSumTypeHandler;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.CmacCamellia128CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.CmacCamellia256CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.Crc32CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.DesCbcCheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HmacMd5Rc4CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HmacSha1Aes128CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HmacSha1Aes256CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HmacSha1Des3CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.Md5HmacRc4CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.RsaMd4CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.RsaMd4DesCheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.RsaMd5CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.RsaMd5DesCheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.Sha1CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class CheckSumHandler {
    public static CheckSumTypeHandler getCheckSumHandler(String cksumType) throws KrbException {
        CheckSumType eTypeEnum = CheckSumType.fromName(cksumType);
        return CheckSumHandler.getCheckSumHandler(eTypeEnum);
    }

    public static CheckSumTypeHandler getCheckSumHandler(int cksumType) throws KrbException {
        CheckSumType eTypeEnum = CheckSumType.fromValue(cksumType);
        return CheckSumHandler.getCheckSumHandler(eTypeEnum);
    }

    public static boolean isImplemented(CheckSumType cksumType) throws KrbException {
        return CheckSumHandler.getCheckSumHandler(cksumType, true) != null;
    }

    public static CheckSumTypeHandler getCheckSumHandler(CheckSumType cksumType) throws KrbException {
        return CheckSumHandler.getCheckSumHandler(cksumType, false);
    }

    private static CheckSumTypeHandler getCheckSumHandler(CheckSumType cksumType, boolean check) throws KrbException {
        AbstractCheckSumTypeHandler cksumHandler = null;
        switch (cksumType) {
            case CRC32: {
                cksumHandler = new Crc32CheckSum();
                break;
            }
            case DES_MAC: {
                cksumHandler = new DesCbcCheckSum();
                break;
            }
            case RSA_MD4: {
                cksumHandler = new RsaMd4CheckSum();
                break;
            }
            case RSA_MD5: {
                cksumHandler = new RsaMd5CheckSum();
                break;
            }
            case NIST_SHA: {
                cksumHandler = new Sha1CheckSum();
                break;
            }
            case RSA_MD4_DES: {
                cksumHandler = new RsaMd4DesCheckSum();
                break;
            }
            case RSA_MD5_DES: {
                cksumHandler = new RsaMd5DesCheckSum();
                break;
            }
            case HMAC_SHA1_DES3: 
            case HMAC_SHA1_DES3_KD: {
                cksumHandler = new HmacSha1Des3CheckSum();
                break;
            }
            case HMAC_SHA1_96_AES128: {
                cksumHandler = new HmacSha1Aes128CheckSum();
                break;
            }
            case HMAC_SHA1_96_AES256: {
                cksumHandler = new HmacSha1Aes256CheckSum();
                break;
            }
            case CMAC_CAMELLIA128: {
                cksumHandler = new CmacCamellia128CheckSum();
                break;
            }
            case CMAC_CAMELLIA256: {
                cksumHandler = new CmacCamellia256CheckSum();
                break;
            }
            case HMAC_MD5_ARCFOUR: {
                cksumHandler = new HmacMd5Rc4CheckSum();
                break;
            }
            case MD5_HMAC_ARCFOUR: {
                cksumHandler = new Md5HmacRc4CheckSum();
                break;
            }
        }
        if (cksumHandler == null && !check) {
            String message = "Unsupported checksum type: " + cksumType.name();
            throw new KrbException(KrbErrorCode.KDC_ERR_SUMTYPE_NOSUPP, message);
        }
        return cksumHandler;
    }

    public static CheckSum checksum(CheckSumType checkSumType, byte[] bytes) throws KrbException {
        CheckSumTypeHandler handler = CheckSumHandler.getCheckSumHandler(checkSumType);
        byte[] checksumBytes = handler.checksum(bytes);
        CheckSum checkSum = new CheckSum();
        checkSum.setCksumtype(checkSumType);
        checkSum.setChecksum(checksumBytes);
        return checkSum;
    }

    public static boolean verify(CheckSum checkSum, byte[] bytes) throws KrbException {
        CheckSumType checkSumType = checkSum.getCksumtype();
        CheckSumTypeHandler handler = CheckSumHandler.getCheckSumHandler(checkSumType);
        return handler.verify(bytes, checkSum.getChecksum());
    }

    public static CheckSum checksumWithKey(CheckSumType checkSumType, byte[] bytes, byte[] key, KeyUsage usage) throws KrbException {
        CheckSumTypeHandler handler = CheckSumHandler.getCheckSumHandler(checkSumType);
        byte[] checksumBytes = handler.checksumWithKey(bytes, key, usage.getValue());
        CheckSum checkSum = new CheckSum();
        checkSum.setCksumtype(checkSumType);
        checkSum.setChecksum(checksumBytes);
        return checkSum;
    }

    public static boolean verifyWithKey(CheckSum checkSum, byte[] bytes, byte[] key, KeyUsage usage) throws KrbException {
        CheckSumType checkSumType = checkSum.getCksumtype();
        CheckSumTypeHandler handler = CheckSumHandler.getCheckSumHandler(checkSumType);
        return handler.verifyWithKey(bytes, key, usage.getValue(), checkSum.getChecksum());
    }
}

