/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.local;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.CedrusDataBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.filesystem.local.CatalogLocalFileSystemConfig;
import ru.cedrusdata.catalog.filesystem.local.CatalogLocalFileSystemModule;
import ru.cedrusdata.catalog.filesystem.local.CatalogLocalTrinoFileSystemFactory;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemProvider;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;

public class CatalogLocalFileSystemProvider
implements CatalogFileSystemProvider {
    public CatalogFileSystemType getFileSystemType() {
        return CatalogFileSystemType.LOCAL;
    }

    public CatalogFileSystemFactory createFileSystemFactory(CatalogPluginContext context, String fileSystemName, Map<String, String> config) {
        Optional<String> error = CatalogLocalFileSystemConfig.validateProperties(config = config != null ? new HashMap<String, String>(config) : new HashMap());
        if (error.isPresent()) {
            throw (RuntimeException)context.configExceptionProvider().apply("Invalid properties: " + error.get());
        }
        ClassLoader classLoader = CatalogLocalFileSystemProvider.class.getClassLoader();
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(classLoader);){
            CedrusDataBootstrap app = new CedrusDataBootstrap(new Module[]{new CatalogLocalFileSystemModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(Map.of()).setOptionalConfigurationProperties(config).quiet().initialize();
            CatalogFileSystemFactory catalogFileSystemFactory = (CatalogFileSystemFactory)injector.getInstance(CatalogLocalTrinoFileSystemFactory.class);
            return catalogFileSystemFactory;
        }
    }
}

