/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.cache.CacheFileSystem;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.tracing.TracingFileSystemCache;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;

public final class CacheFileSystemFactory
implements TrinoFileSystemFactory {
    private final Tracer tracer;
    private final TrinoFileSystemFactory delegate;
    private final TrinoFileSystemCache cache;
    private final CacheKeyProvider keyProvider;

    public CacheFileSystemFactory(Tracer tracer, TrinoFileSystemFactory delegate, TrinoFileSystemCache cache, CacheKeyProvider keyProvider) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = Objects.requireNonNull(cache, "cache is null");
        this.keyProvider = Objects.requireNonNull(keyProvider, "keyProvider is null");
    }

    @Override
    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new CacheFileSystem(this.delegate.create(identity), new TracingFileSystemCache(this.tracer, this.cache), this.keyProvider);
    }
}

