/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.common;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import java.io.IOException;
import java.util.Collection;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemInputFile;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemOutputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemInputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemOutputFile;

public class CatalogTrinoFileSystem
implements CatalogFileSystem {
    private final TrinoFileSystem delegate;

    public CatalogTrinoFileSystem(TrinoFileSystem delegate) {
        this.delegate = delegate;
    }

    public CatalogFileSystemInputFile newInputFile(String location) {
        return new CatalogTrinoFileSystemInputFile(this.delegate.newInputFile(Location.of((String)location)));
    }

    public CatalogFileSystemInputFile newInputFile(String location, long length) {
        return new CatalogTrinoFileSystemInputFile(this.delegate.newInputFile(Location.of((String)location), length));
    }

    public CatalogFileSystemOutputFile newOutputFile(String location) {
        return new CatalogTrinoFileSystemOutputFile(this.delegate.newOutputFile(Location.of((String)location)));
    }

    public void deleteFile(String location) throws IOException {
        this.delegate.deleteFile(Location.of((String)location));
    }

    public void deleteFiles(Collection<String> locations) throws IOException {
        this.delegate.deleteFiles(locations.stream().map(Location::of).toList());
    }
}

