-- Delete duplicates
DELETE FROM metastore_object_group_item
WHERE group_item_id IN (
    SELECT t1.group_item_id
    FROM metastore_object_group_item t1
             JOIN metastore_object_group_item t2 ON
                t1.group_id = t2.group_id
                AND (t1.namespace_id = t2.namespace_id OR (t1.namespace_id IS NULL AND t2.namespace_id IS NULL))
                AND (t1.object_id = t2.object_id OR (t1.object_id IS NULL AND t2.object_id IS NULL))
                AND t1.group_item_id < t2.group_item_id
);

-- Set special group_item_id for wildcard items where namespace_id and object_id are NULL
UPDATE metastore_object_group_item SET group_item_id = group_id WHERE namespace_id IS NULL AND object_id IS NULL;

-- Add constraints to prevent duplicate items
ALTER TABLE metastore_object_group_item ADD CONSTRAINT metastore_object_group_item_unique_group_id_namespace_id UNIQUE (group_id, namespace_id);
ALTER TABLE metastore_object_group_item ADD CONSTRAINT metastore_object_group_item_unique_group_id_object_id UNIQUE (group_id, object_id);
