-- Add principal_type: 0 - user, 1 - role
ALTER TABLE metastore_principal ADD COLUMN principal_type SMALLINT NOT NULL DEFAULT 0;

-- Make hashed_password optional because roles do not have passwords. Use new column because SQLite doesn't support ALTER COLUMN
ALTER TABLE metastore_principal ADD COLUMN new_hashed_password VARCHAR;
UPDATE metastore_principal SET new_hashed_password = hashed_password;
ALTER TABLE metastore_principal DROP COLUMN hashed_password;
ALTER TABLE metastore_principal RENAME COLUMN new_hashed_password TO hashed_password;

-- Insert roles into principal table
INSERT INTO metastore_principal (principal_id, principal_name, principal_type, active)
SELECT role_id, role_name, 1, 1
FROM metastore_role;

-- Redirect role_id foreign key in role_grant table towards principal table
CREATE TABLE metastore_role_grant_new(
  principal_id UUID,
  role_id UUID,
  PRIMARY KEY (principal_id, role_id),
  FOREIGN KEY (principal_id) REFERENCES metastore_principal(principal_id) ON DELETE CASCADE,
  FOREIGN KEY (role_id) REFERENCES metastore_principal(principal_id)
);

INSERT INTO metastore_role_grant_new(principal_id, role_id)
SELECT principal_id, role_id
FROM metastore_role_grant;

DROP TABLE metastore_role_grant;

ALTER TABLE metastore_role_grant_new RENAME TO metastore_role_grant;

CREATE INDEX metastore_role_grant_token_idx_principal_id ON metastore_role_grant(principal_id);
CREATE INDEX metastore_role_grant_token_idx_role_id ON metastore_role_grant(role_id);

-- Drop role table which is no longer used
DROP TABLE metastore_role;

-- Add built-in principals
INSERT INTO metastore_principal (principal_id, principal_name, principal_type, active) VALUES ('14553a78-e42c-4b69-abdb-075eaa85cdf8', 'builtin.admin', 1, 1) ON CONFLICT DO NOTHING;
INSERT INTO metastore_principal (principal_id, principal_name, principal_type, active) VALUES ('53d26275-2f27-4b83-a5f1-81c5b8486bb6', 'builtin.iceberg-catalog.data-owner', 1, 1) ON CONFLICT DO NOTHING;

-- Rename Iceberg built-in role
UPDATE metastore_principal SET principal_name = 'builtin.iceberg.admin' WHERE principal_name = 'builtin.iceberg-catalog.data-owner';
