/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;

public class TableMappingRule {
    private final String remoteSchema;
    private final String remoteTable;
    private final String mapping;

    @JsonCreator
    public TableMappingRule(@JsonProperty String remoteSchema, @JsonProperty String remoteTable, @JsonProperty String mapping) {
        this.remoteSchema = Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        this.remoteTable = Objects.requireNonNull(remoteTable, "remoteTable is null");
        this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        Preconditions.checkArgument((boolean)mapping.toLowerCase(Locale.ENGLISH).equals(mapping), (String)"Mapping is not lower cased: %s", (Object)mapping);
    }

    @JsonProperty
    public String getRemoteSchema() {
        return this.remoteSchema;
    }

    @JsonProperty
    public String getRemoteTable() {
        return this.remoteTable;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMappingRule that = (TableMappingRule)o;
        return this.remoteSchema.equals(that.remoteSchema) && this.remoteTable.equals(that.remoteTable) && this.mapping.equals(that.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.remoteSchema, this.remoteTable, this.mapping);
    }
}

