/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorPageSourceProviderFactory;
import java.util.Objects;

public class ClassLoaderSafeConnectorPageSourceProviderFactory
implements ConnectorPageSourceProviderFactory {
    private final ConnectorPageSourceProviderFactory delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorPageSourceProviderFactory(@ForClassLoaderSafe ConnectorPageSourceProviderFactory delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorPageSourceProvider createPageSourceProvider() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSourceProvider classLoaderSafeConnectorPageSourceProvider = new ClassLoaderSafeConnectorPageSourceProvider(this.delegate.createPageSourceProvider(), this.classLoader);
            return classLoaderSafeConnectorPageSourceProvider;
        }
    }
}

