/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.multibindings.Multibinder;
import io.trino.plugin.base.util.AutoCloseableCloser;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ClosingBinder {
    private final Multibinder<ExecutorService> executors;
    private final Multibinder<AutoCloseable> closeables;

    public static ClosingBinder closingBinder(Binder binder) {
        return new ClosingBinder(binder);
    }

    private ClosingBinder(Binder binder) {
        this.executors = Multibinder.newSetBinder((Binder)binder, ExecutorService.class, ForCleanup.class);
        this.closeables = Multibinder.newSetBinder((Binder)binder, AutoCloseable.class, ForCleanup.class);
        binder.bind(Cleanup.class).asEagerSingleton();
    }

    public void registerExecutor(Class<? extends ExecutorService> type) {
        this.registerExecutor((Key<? extends ExecutorService>)Key.get(type));
    }

    public void registerExecutor(Key<? extends ExecutorService> key) {
        this.executors.addBinding().to(Objects.requireNonNull(key, "key is null"));
    }

    public void registerCloseable(Class<? extends AutoCloseable> type) {
        this.registerCloseable((Key<? extends AutoCloseable>)Key.get(type));
    }

    public void registerCloseable(Key<? extends AutoCloseable> key) {
        this.closeables.addBinding().to(key);
    }

    public <T> void registerResource(Class<T> type, Consumer<? super T> close) {
        this.registerResource(Key.get(type), close);
    }

    public <T> void registerResource(Key<T> key, Consumer<? super T> close) {
        this.closeables.addBinding().toProvider(new ResourceCloser<T>(key, close));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    private static @interface ForCleanup {
    }

    private record Cleanup(@ForCleanup Set<ExecutorService> executors, @ForCleanup Set<AutoCloseable> closeables) {
        @Inject
        private Cleanup {
            executors = ImmutableSet.copyOf(executors);
            closeables = ImmutableSet.copyOf(closeables);
        }

        @PreDestroy
        public void shutdown() throws Exception {
            try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
                this.executors.forEach(executor -> closer.register(executor::shutdownNow));
                this.closeables.forEach(closer::register);
            }
        }
    }

    private static class ResourceCloser<T>
    implements Provider<AutoCloseable> {
        private final Key<T> key;
        private final Consumer<? super T> close;
        private Injector injector;

        private ResourceCloser(Key<T> key, Consumer<? super T> close) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.close = Objects.requireNonNull(close, "close is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public AutoCloseable get() {
            Object object = this.injector.getInstance(this.key);
            Verify.verifyNotNull((Object)object, (String)"null at key %s", (Object[])new Object[]{this.key});
            Consumer close = this.close;
            return () -> close.accept(object);
        }
    }
}

