/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.SetObjectArgumentFactory;
import org.postgresql.util.PSQLException;
import ru.cedrusdata.catalog.store.jdbc.SqlDialect;

public class PostgresqlSqlDialect
implements SqlDialect {
    private static final Set<String> CONSTRAINT_VIOLATION_SQL_STATES_CODES = Set.of("23000", "23001", "23502", "23503", "23505", "23514", "23P01");

    @Override
    public boolean isConstraintViolationException(Throwable throwable) {
        if (throwable instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)throwable;
            return CONSTRAINT_VIOLATION_SQL_STATES_CODES.contains(psqlException.getSQLState());
        }
        return false;
    }

    @Override
    public UUID getUuid(ResultSet rs, String columnLabel) throws SQLException {
        return rs.getObject(columnLabel, UUID.class);
    }

    @Override
    public String forUpdate(String sql) {
        return sql.replace("{for-update}", "FOR UPDATE");
    }

    @Override
    public void customizeJdbi(Jdbi jdbi) {
        jdbi.registerArgument((ArgumentFactory)new UUIDArgumentFactory());
    }

    private static class UUIDArgumentFactory
    extends SetObjectArgumentFactory {
        public UUIDArgumentFactory() {
            super(Collections.singletonMap(UUID.class, 1111));
        }
    }
}

