/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

public class PageProcessor<T> {
    private final ListQueryBuilder<T> listQueryBuilder;
    private final Optional<String> pageToken;
    private final int limit;

    public PageProcessor(ListQueryBuilder<T> listQueryBuilder, Optional<String> pageToken, int limit) {
        this.listQueryBuilder = listQueryBuilder;
        this.pageToken = pageToken;
        this.limit = limit;
    }

    public Query createQuery(Handle handle) {
        return this.createQuery(handle, List.of());
    }

    public Query createQuery(Handle handle, QueryCondition condition) {
        return this.createQuery(handle, List.of(condition));
    }

    public Query createQuery(Handle handle, List<QueryCondition> conditions) {
        String sql = (this.pageToken.isEmpty() ? this.listQueryBuilder.withoutOffset() : this.listQueryBuilder.withOffset()).build(conditions);
        Query query = handle.createQuery(sql);
        for (QueryCondition condition : conditions) {
            condition.bind(query);
        }
        if (this.pageToken.isPresent()) {
            this.listQueryBuilder.sort().bindToken(query, this.pageToken.get());
        }
        query.bind("limit", this.limit);
        return query;
    }

    public String nextPageToken(List<T> results) {
        if (results == null || this.limit > results.size()) {
            return null;
        }
        T last = results.getLast();
        String value = this.listQueryBuilder.sort().createToken(last);
        Verify.verify((value != null ? 1 : 0) != 0);
        return value.toString();
    }

    public int limit() {
        return this.limit;
    }
}

