/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationInfoEx;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationListResponse;
import ru.cedrusdata.catalog.store.MaintenanceOperationStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcMaintenanceOperationStore
implements MaintenanceOperationStore {
    @Language(value="SQL")
    private static final String SQL_CREATE = "INSERT INTO metastore_maintenance_operation (\n    engine_id,\n    operation_id,\n    operation_name,\n    operation_parameters,\n    job_id,\n    target_object_group_id,\n    target_object_id,\n    engine_config,\n    owner_id,\n    started_at)\nVALUES (\n    :engine_id,\n    :operation_id,\n    :operation_name,\n    :operation_parameters,\n    :job_id,\n    :target_object_group_id,\n    :target_object_id,\n    :engine_config,\n    :owner_id,\n    :started_at)\n";
    @Language(value="SQL")
    private static final String SQL_CREATE_FAILED = "INSERT INTO metastore_maintenance_operation (\n    error,\n    engine_id,\n    operation_id,\n    operation_name,\n    operation_parameters,\n    job_id,\n    target_object_group_id,\n    target_object_id,\n    engine_config,\n    owner_id,\n    started_at,\n    completed_at)\nVALUES (\n    :error,\n    :engine_id,\n    :operation_id,\n    :operation_name,\n    :operation_parameters,\n    :job_id,\n    :target_object_group_id,\n    :target_object_id,\n    :engine_config,\n    :owner_id,\n    :started_at,\n    :started_at)\n";
    @Language(value="SQL")
    private static final String SQL_COMPLETE_ACTIVE = "UPDATE metastore_maintenance_operation\nSET\n    completed_at = :completed_at,\n    result = :result,\n    object_errors = :object_errors,\n    error = :error\nWHERE operation_id = :operation_id AND completed_at IS NULL\n";
    @Language(value="SQL")
    private static final String SQL_COMPLETE_ALL_ACTIVE = "UPDATE metastore_maintenance_operation\nSET\n    completed_at = :completed_at,\n    error = :error\nWHERE completed_at IS NULL\n";
    @Language(value="SQL")
    private static final String SQL_DELETE_COMPLETED = "DELETE FROM metastore_maintenance_operation\nWHERE completed_at < :completed_at\n";
    @Language(value="SQL")
    private static final String SQL_INFO = "SELECT\n    e.owner_id engine_owner_id,\n    e.engine_name engine_name,\n    o.operation_id,\n    o.operation_name,\n    o.operation_parameters,\n    e.engine_id,\n    e.engine_name,\n    job.job_name job_name,\n    g.group_name target_object_group_name,\n    c.catalog_name target_catalog_name,\n    n.namespace_name target_namespace_name,\n    t.table_name target_object_name,\n    o.target_object_id,\n    o.engine_config,\n    o.owner_id,\n    p.principal_name owner_name,\n    o.started_at,\n    o.completed_at,\n    o.result,\n    o.object_errors,\n    o.error\nFROM metastore_maintenance_operation o\n    INNER JOIN metastore_compute_engine e ON o.engine_id = e.engine_id\n    LEFT JOIN metastore_object_group g ON o.target_object_group_id = g.group_id\n    LEFT JOIN metastore_iceberg_table t ON o.target_object_id = t.table_id\n    LEFT JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    LEFT JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT JOIN metastore_principal p ON o.owner_id = p.principal_id\n    LEFT JOIN metastore_maintenance_job job ON o.job_id = job.job_id\nWHERE operation_id = :operation_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST = "SELECT\n    e.owner_id engine_owner_id,\n    e.engine_name engine_name,\n    o.operation_id,\n    o.operation_name,\n    o.operation_parameters,\n    e.engine_id,\n    e.engine_name,\n    job_name,\n    g.group_name target_object_group_name,\n    c.catalog_name target_catalog_name,\n    n.namespace_name target_namespace_name,\n    t.table_name target_object_name,\n    o.target_object_id,\n    o.engine_config,\n    o.owner_id,\n    p.principal_name owner_name,\n    o.started_at,\n    o.completed_at,\n    o.result,\n    o.object_errors,\n    o.error\nFROM metastore_maintenance_operation o\n    INNER JOIN metastore_compute_engine e ON o.engine_id = e.engine_id\n    LEFT JOIN metastore_object_group g ON o.target_object_group_id = g.group_id\n    LEFT JOIN metastore_iceberg_table t ON o.target_object_id = t.table_id\n    LEFT JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    LEFT JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT JOIN metastore_principal p ON o.owner_id = p.principal_id\n    LEFT JOIN metastore_maintenance_job job ON o.job_id = job.job_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<MaintenanceOperationInfoEx> listPageProcessorFactory;

    @Inject
    public JdbcMaintenanceOperationStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        this.listPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_LIST, PageSort.sort(PageSort.bigintSort("started_at", info -> info.info().getStartedAt()), PageSort.uuidSort("operation_id", info -> info.info().getOperationId()))), config.getStoreMaxPageSize());
    }

    @Override
    public void create(UUID engineId, UUID operationId, String operationName, Map<String, String> operationParameters, Optional<UUID> jobId, Optional<UUID> targetObjectGroupId, Optional<UUID> targetObjectId, Map<String, String> engineConfig, UUID ownerId, long startedAt) {
        this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_CREATE).bind("engine_id", engineId)).bind("operation_id", operationId)).bind("operation_name", operationName)).bind("operation_parameters", JdbcUtils.propertiesToString(operationParameters))).bind("job_id", (UUID)jobId.orElse(null))).bind("target_object_group_id", (UUID)targetObjectGroupId.orElse(null))).bind("target_object_id", (UUID)targetObjectId.orElse(null))).bind("engine_config", JdbcUtils.propertiesToString(engineConfig))).bind("owner_id", ownerId)).bind("started_at", startedAt)).execute());
    }

    @Override
    public void createFailed(String error, UUID engineId, UUID operationId, String operationName, Map<String, String> operationParameters, Optional<UUID> jobId, Optional<UUID> targetObjectGroupId, Optional<UUID> targetObjectId, Map<String, String> engineConfig, UUID ownerId, long startedAt) {
        this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_CREATE_FAILED).bind("error", error)).bind("engine_id", engineId)).bind("operation_id", operationId)).bind("operation_name", operationName)).bind("operation_parameters", JdbcUtils.propertiesToString(operationParameters))).bind("job_id", (UUID)jobId.orElse(null))).bind("target_object_group_id", (UUID)targetObjectGroupId.orElse(null))).bind("target_object_id", (UUID)targetObjectId.orElse(null))).bind("engine_config", JdbcUtils.propertiesToString(engineConfig))).bind("owner_id", ownerId)).bind("started_at", startedAt)).execute());
    }

    @Override
    public void completeActive(UUID operationId, long completedAt, Optional<Map<String, String>> result, Optional<Map<String, String>> objectErrors, Optional<String> error) {
        this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_COMPLETE_ACTIVE).bind("operation_id", operationId)).bind("completed_at", completedAt)).bind("result", (String)result.map(JdbcUtils::propertiesToString).orElse(null))).bind("object_errors", (String)objectErrors.map(JdbcUtils::propertiesToString).orElse(null))).bind("error", (String)error.orElse(null))).execute());
    }

    @Override
    public int completeAllActive(long completedAt, String error) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_COMPLETE_ALL_ACTIVE).bind("completed_at", completedAt)).bind("error", error)).execute());
    }

    @Override
    public int deleteCompleted(long minCompletedAt) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_DELETE_COMPLETED).bind("completed_at", minCompletedAt)).execute());
    }

    @Override
    public Optional<MaintenanceOperationInfoEx> info(UUID operationId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_INFO).bind("operation_id", operationId)).map((rs, ctx) -> this.toInfo(rs)).findOne());
    }

    private MaintenanceOperationInfoEx toInfo(ResultSet rs) throws SQLException {
        UUID engineId = this.accessor.getUuid(rs, "engine_id");
        Optional<UUID> engineOwnerId = this.accessor.getOptionalUuid(rs, "engine_owner_id");
        Optional<UUID> ownerId = this.accessor.getOptionalUuid(rs, "owner_id");
        MaintenanceOperationInfo info = new MaintenanceOperationInfo(this.accessor.getUuid(rs, "operation_id"), new MaintenanceOperationConfig(rs.getString("engine_name"), JdbcUtils.stringToProperties(rs.getString("engine_config")), rs.getString("operation_name"), JdbcUtils.stringToProperties(rs.getString("operation_parameters"))), rs.getString("target_object_group_name"), rs.getString("target_catalog_name"), rs.getString("target_namespace_name"), rs.getString("target_object_name"), rs.getString("owner_name"), Long.valueOf(rs.getLong("started_at")), this.accessor.getLongOrNull(rs, "completed_at"), JdbcUtils.stringToPropertiesOrNull(rs.getString("result")), JdbcUtils.stringToPropertiesOrNull(rs.getString("object_errors")), rs.getString("error"), rs.getString("job_name"));
        return new MaintenanceOperationInfoEx(info, engineId, engineOwnerId, ownerId);
    }

    @Override
    public MaintenanceOperationListResponse list(ResultPage page, Predicate<MaintenanceOperationInfoEx> predicate, List<QueryCondition> conditions) {
        return this.listPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), this::toInfo, predicate, (items, nextPageToken) -> new MaintenanceOperationListResponse(items.stream().map(MaintenanceOperationInfoEx::info).toList(), nextPageToken));
    }
}

