/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import java.lang.reflect.AccessFlag;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.jdbi.v3.core.ConnectionFactory;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.config.store.CatalogJdbcStoreConfig;
import ru.cedrusdata.catalog.store.ComputeEngineStore;
import ru.cedrusdata.catalog.store.FileSystemStore;
import ru.cedrusdata.catalog.store.IcebergCatalogStore;
import ru.cedrusdata.catalog.store.IcebergNamespaceStore;
import ru.cedrusdata.catalog.store.IcebergObjectStore;
import ru.cedrusdata.catalog.store.MaintenanceJobStore;
import ru.cedrusdata.catalog.store.MaintenanceOperationStore;
import ru.cedrusdata.catalog.store.ObjectGroupStore;
import ru.cedrusdata.catalog.store.PrincipalStore;
import ru.cedrusdata.catalog.store.PrivilegeStore;
import ru.cedrusdata.catalog.store.SecurityProviderStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcComputeEngineStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.JdbcDirectConnectionFactory;
import ru.cedrusdata.catalog.store.jdbc.JdbcDirectDataSource;
import ru.cedrusdata.catalog.store.jdbc.JdbcFileSystemStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcHikariDataSourceConnectionFactory;
import ru.cedrusdata.catalog.store.jdbc.JdbcIcebergCatalogStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcIcebergNamespaceStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcIcebergObjectStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcMaintenanceJobStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcMaintenanceOperationStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcObjectGroupStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcPrincipalStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcPrivilegeStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcSecurityProviderStore;

public class JdbcCatalogStoreModule
extends AbstractConfigurationAwareModule {
    private final Module baseModule;

    public JdbcCatalogStoreModule(Module baseModule) {
        this.baseModule = baseModule;
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogJdbcStoreConfig.class);
        binder.bind(JdbcAccessor.class).in(Scopes.SINGLETON);
        binder.bind(PrincipalStore.class).to(JdbcPrincipalStore.class).in(Scopes.SINGLETON);
        binder.bind(PrivilegeStore.class).to(JdbcPrivilegeStore.class).in(Scopes.SINGLETON);
        binder.bind(FileSystemStore.class).to(JdbcFileSystemStore.class).in(Scopes.SINGLETON);
        binder.bind(ComputeEngineStore.class).to(JdbcComputeEngineStore.class).in(Scopes.SINGLETON);
        binder.bind(ObjectGroupStore.class).to(JdbcObjectGroupStore.class).in(Scopes.SINGLETON);
        binder.bind(IcebergCatalogStore.class).to(JdbcIcebergCatalogStore.class).in(Scopes.SINGLETON);
        binder.bind(IcebergNamespaceStore.class).to(JdbcIcebergNamespaceStore.class).in(Scopes.SINGLETON);
        binder.bind(IcebergObjectStore.class).to(JdbcIcebergObjectStore.class).in(Scopes.SINGLETON);
        binder.bind(MaintenanceOperationStore.class).to(JdbcMaintenanceOperationStore.class).in(Scopes.SINGLETON);
        binder.bind(MaintenanceJobStore.class).to(JdbcMaintenanceJobStore.class).in(Scopes.SINGLETON);
        binder.bind(SecurityProviderStore.class).to(JdbcSecurityProviderStore.class).in(Scopes.SINGLETON);
        if (((CatalogConfig)this.buildConfigObject(CatalogConfig.class)).getTelemetryEnabled().traceStore()) {
            StoreTracingInterceptor interceptor = new StoreTracingInterceptor();
            binder.requestInjection((Object)interceptor);
            binder.bindInterceptor(Matchers.annotatedWith(StoreTracingInterceptor.Traceable.class), method -> method.accessFlags().contains((Object)AccessFlag.PUBLIC), new MethodInterceptor[]{interceptor});
        }
        super.install(this.baseModule);
    }

    @Provides
    @Singleton
    public static JdbcDirectConnectionFactory getDirectConnectionFactory(JdbcConnectionDetails connectionDetails) {
        return new JdbcDirectConnectionFactory(connectionDetails);
    }

    @Provides
    @Singleton
    public static ConnectionFactory getConnectionFactory(JdbcDirectConnectionFactory directConnectionFactory, CatalogJdbcStoreConfig config) {
        if (config.getStoreJdbcConnectionPoolSize() > 0) {
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setMaximumPoolSize(config.getStoreJdbcConnectionPoolSize());
            hikariConfig.setIdleTimeout(config.getStoreJdbcConnectionPoolTtl().toMillis());
            hikariConfig.setDataSource((DataSource)new JdbcDirectDataSource(directConnectionFactory));
            HikariDataSource dataSource = new HikariDataSource(hikariConfig);
            return new JdbcHikariDataSourceConnectionFactory(dataSource);
        }
        return directConnectionFactory;
    }
}

