/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.store.jdbc.JdbcCatalogStoreModule;
import ru.cedrusdata.catalog.store.jdbc.postgres.PostgresqlCatalogStoreModule;
import ru.cedrusdata.catalog.store.jdbc.sqlite.SqliteCatalogStoreModule;

public class CatalogStoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogStoreConfig.class);
        CatalogStoreConfig storeConfig = (CatalogStoreConfig)this.buildConfigObject(CatalogStoreConfig.class);
        switch (storeConfig.getStoreType()) {
            case SQLITE: {
                super.install((Module)new JdbcCatalogStoreModule(new SqliteCatalogStoreModule()));
                break;
            }
            case POSTGRESQL: {
                super.install((Module)new JdbcCatalogStoreModule(new PostgresqlCatalogStoreModule()));
                break;
            }
            default: {
                throw new CatalogInternalServerErrorException("Unsupported catalog store: " + String.valueOf((Object)storeConfig.getStoreType()));
            }
        }
    }
}

