/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Objects;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.model.ServerInfo;

@ResourceType(value=ResourceType.Type.CATALOG)
@ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
@Path(value="/v1/info")
public class V1InfoApi {
    private final EmbeddedInternalCatalogClientFactory clientFactory;

    @Inject
    public V1InfoApi(EmbeddedInternalCatalogClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
    }

    @GET
    @Produces(value={"application/json"})
    public Response info(SecurityContext securityContext) {
        AuthenticationContext context = CatalogUtils.getAuthenticatedContextOrAnonymous(securityContext);
        ServerInfo info = this.clientFactory.createClient(context).info();
        return Response.ok((Object)info).build();
    }
}

