/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.filters;

import io.airlift.jaxrs.tracing.TracingFilterUtils;
import io.opentelemetry.api.trace.Span;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;
import java.util.UUID;
import ru.cedrusdata.catalog.tracing.TracingAttributes;

@Priority(value=1)
public class RequestIdFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String MESSAGE_CORRELATION_ID = "correlation-id";
    private static final String HEADER_CORRELATION_ID = "X-Correlation-ID";
    private static final String PROPERTY_CORRELATION_ID = "cedrusdata.catalog.$internal.correlation-id";

    public void filter(ContainerRequestContext requestContext) {
        String correlationId = requestContext.getHeaderString(HEADER_CORRELATION_ID);
        if (correlationId == null) {
            correlationId = UUID.randomUUID().toString();
        }
        requestContext.setProperty(PROPERTY_CORRELATION_ID, (Object)correlationId);
        Span span = (Span)requestContext.getProperty(TracingFilterUtils.getRequestSpanProperty());
        if (span != null) {
            span.setAttribute(TracingAttributes.CORRELATION_ID, (Object)correlationId);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String requestId = (String)requestContext.getProperty(PROPERTY_CORRELATION_ID);
        if (requestId != null) {
            responseContext.getHeaders().add((Object)HEADER_CORRELATION_ID, (Object)requestId);
        }
    }

    public static String getCorrelation(HttpServletRequest request) {
        return (String)request.getAttribute(PROPERTY_CORRELATION_ID);
    }
}

