/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import org.apache.iceberg.rest.RESTSerializers;
import ru.cedrusdata.catalog.iceberg.CedrusDataRESTSerializers;

public class JsonModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(JsonCodecFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    public ObjectMapper createJsonMapper() {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        objectMapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS});
        objectMapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        objectMapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
        objectMapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS});
        objectMapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
        objectMapper.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());
        RESTSerializers.registerAll((ObjectMapper)objectMapper);
        CedrusDataRESTSerializers.registerAll((ObjectMapper)objectMapper);
        return objectMapper;
    }
}

