/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.common.io.Resources;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

@Path(value="/favicon.ico")
@ResourceSecurity(value=ResourceSecurity.Type.PUBLIC)
@ResourceType(value=ResourceType.Type.CATALOG)
public class FaviconResource {
    private static final String PATH = "favicon.ico";
    private volatile byte[] data;

    @GET
    @Produces(value={"image/x-icon"})
    public Response favicon() {
        if (this.data == null) {
            this.data = FaviconResource.getFavicon();
        }
        return Response.ok((Object)new ByteArrayInputStream(this.data)).build();
    }

    private static byte[] getFavicon() {
        byte[] byArray;
        block8: {
            InputStream stream = Resources.getResource((String)PATH).openStream();
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CatalogInternalServerErrorException(String.format("Failed to read %s", PATH), (Throwable)e);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

