/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PluginPropertyClassifier {
    private final Map<String, Set<String>> redactedPropertyKeys;

    private PluginPropertyClassifier(Map<String, Set<String>> redactedPropertyKeys) {
        this.redactedPropertyKeys = redactedPropertyKeys;
    }

    public boolean shouldRedact(String type, String propertyName) {
        return this.redactedPropertyKeys.get(type).contains(propertyName);
    }

    public static class Builder {
        private final Map<String, Set<String>> allRedactedPropertyKeys = new HashMap<String, Set<String>>();

        public Builder add(String type, Set<String> redactedPropertyKeys) {
            this.allRedactedPropertyKeys.put(type, redactedPropertyKeys);
            return this;
        }

        public PluginPropertyClassifier build() {
            return new PluginPropertyClassifier(this.allRedactedPropertyKeys);
        }
    }
}

