/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataUtils;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataUtils;

public class IcebergTableUtils {
    private IcebergTableUtils() {
    }

    public static boolean isMaterializedView(Map<String, String> tableProperties) {
        return tableProperties.containsKey("cedrusdata-mv-definition");
    }

    public static Optional<Long> cteTableTtl(Map<String, String> tableProperties) {
        long ttl;
        String ttlStr = tableProperties.get("cedrusdata-cte-ttl");
        if (ttlStr == null) {
            return Optional.empty();
        }
        try {
            ttl = Long.parseLong(ttlStr);
            if (ttl <= 0L) {
                throw new BadRequestException("CTE TTL must be positive: %s", new Object[]{ttlStr});
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Cannot parse CTE TTL: %s", new Object[]{ttlStr});
        }
        return Optional.of(ttl);
    }

    public static Optional<LoadTableResponse> applyAsOfToTableResponse(LoadTableResponse original, long timestampMillis) {
        TableMetadata originalMetadata = original.tableMetadata();
        Optional<TableMetadata> newMetadata = IcebergTableUtils.applyAsOfToTableMetadata(originalMetadata, timestampMillis);
        if (newMetadata.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(LoadTableResponse.builder().withTableMetadata(newMetadata.get()).build());
    }

    private static Optional<TableMetadata> applyAsOfToTableMetadata(TableMetadata tableMetadata, long timestampMillis) {
        OptionalLong maybeSnapshotId = IcebergTableUtils.tableSnapshotIdAsOfTimestamp(tableMetadata, timestampMillis);
        if (maybeSnapshotId.isEmpty()) {
            return Optional.empty();
        }
        long snapshotId = maybeSnapshotId.getAsLong();
        if (tableMetadata.currentSnapshot().snapshotId() == snapshotId) {
            return Optional.of(tableMetadata);
        }
        return Optional.of(TableMetadataUtils.adjustToSnapshot(tableMetadata, snapshotId));
    }

    private static OptionalLong tableSnapshotIdAsOfTimestamp(TableMetadata tableMetadata, long timestampMillis) {
        Long snapshotId = null;
        for (HistoryEntry logEntry : tableMetadata.snapshotLog()) {
            if (logEntry.timestampMillis() > timestampMillis) continue;
            snapshotId = logEntry.snapshotId();
        }
        return snapshotId != null ? OptionalLong.of(snapshotId) : OptionalLong.empty();
    }

    public static Optional<LoadViewResponse> applyAsOfToViewResponse(LoadViewResponse original, long timestampMillis) {
        ViewMetadata originalMetadata = original.metadata();
        Optional<ViewMetadata> newMetadata = IcebergTableUtils.applyAsOfToViewMetadata(originalMetadata, timestampMillis);
        if (newMetadata.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableLoadViewResponse.builder().metadata(newMetadata.get()).metadataLocation(newMetadata.get().metadataFileLocation()).build());
    }

    private static Optional<ViewMetadata> applyAsOfToViewMetadata(ViewMetadata viewMetadata, long timestampMillis) {
        OptionalInt maybeVersionId = IcebergTableUtils.viewVersionIdAsOfTimestamp(viewMetadata, timestampMillis);
        if (maybeVersionId.isEmpty()) {
            return Optional.empty();
        }
        int versionId = maybeVersionId.getAsInt();
        if (viewMetadata.currentVersionId() == versionId) {
            return Optional.of(viewMetadata);
        }
        return Optional.of(ViewMetadataUtils.adjustToVersion(viewMetadata, versionId));
    }

    private static OptionalInt viewVersionIdAsOfTimestamp(ViewMetadata viewMetadata, long timestampMillis) {
        Integer versionId = null;
        for (ViewHistoryEntry logEntry : viewMetadata.history()) {
            if (logEntry.timestampMillis() > timestampMillis) continue;
            versionId = logEntry.versionId();
        }
        return versionId != null ? OptionalInt.of(versionId) : OptionalInt.empty();
    }
}

