/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.securable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.model.Securable;

public record UnboundSecurableInfo(SecurableType parentType, SecurableType targetType, List<String> names) {
    public String name(int index) {
        return this.names.get(index);
    }

    public static UnboundSecurableInfo resolve(Securable securable) {
        if (securable == null) {
            securable = Securable.newBuilder().build();
        }
        if (securable.getPrincipalName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_PRINCIPAL))) {
                throw new CatalogBadRequestException("Principal cannot be used with other securables");
            }
            String normalizedPrincipalName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_PRINCIPAL, securable.getPrincipalName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedPrincipalName, SecurableType.SECURABLE_TYPE_PRINCIPAL), SecurableType.SECURABLE_TYPE_PRINCIPAL, List.of(normalizedPrincipalName));
        }
        if (securable.getFileSystemName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_FILE_SYSTEM))) {
                throw new CatalogBadRequestException("File system cannot be used with other securables");
            }
            String normalizedFileSystemName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_FILE_SYSTEM, securable.getFileSystemName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedFileSystemName, SecurableType.SECURABLE_TYPE_FILE_SYSTEM), SecurableType.SECURABLE_TYPE_FILE_SYSTEM, List.of(normalizedFileSystemName));
        }
        if (securable.getTableName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_CATALOG, SecurableType.SECURABLE_TYPE_NAMESPACE, SecurableType.SECURABLE_TYPE_TABLE))) {
                throw new CatalogBadRequestException("Table can only be used with catalog or namespace");
            }
            String normalizedTableName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_OBJECT, securable.getTableName());
            String normalizedNamespaceName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_NAMESPACE, securable.getNamespaceName());
            String normalizedCatalogName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_CATALOG, securable.getCatalogName());
            if (!UnboundSecurableInfo.isWildcard(normalizedTableName) && UnboundSecurableInfo.isWildcard(normalizedNamespaceName)) {
                throw new CatalogBadRequestException("Namespace cannot be a wildcard when table is not a wildcard");
            }
            if (!UnboundSecurableInfo.isWildcard(normalizedNamespaceName) && UnboundSecurableInfo.isWildcard(normalizedCatalogName)) {
                throw new CatalogBadRequestException("Catalog cannot be a wildcard when namespace is not a wildcard");
            }
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedCatalogName, SecurableType.SECURABLE_TYPE_CATALOG, normalizedNamespaceName, SecurableType.SECURABLE_TYPE_NAMESPACE, normalizedTableName, SecurableType.SECURABLE_TYPE_TABLE), SecurableType.SECURABLE_TYPE_TABLE, List.of(normalizedCatalogName, normalizedNamespaceName, normalizedTableName));
        }
        if (securable.getViewName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_CATALOG, SecurableType.SECURABLE_TYPE_NAMESPACE, SecurableType.SECURABLE_TYPE_VIEW))) {
                throw new CatalogBadRequestException("View can only be used with catalog or namespace");
            }
            String normalizedViewName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_OBJECT, securable.getViewName());
            String normalizedNamespaceName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_NAMESPACE, securable.getNamespaceName());
            String normalizedCatalogName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_CATALOG, securable.getCatalogName());
            if (!UnboundSecurableInfo.isWildcard(normalizedViewName) && UnboundSecurableInfo.isWildcard(normalizedNamespaceName)) {
                throw new CatalogBadRequestException("Namespace cannot be a wildcard when view is not a wildcard");
            }
            if (!UnboundSecurableInfo.isWildcard(normalizedNamespaceName) && UnboundSecurableInfo.isWildcard(normalizedCatalogName)) {
                throw new CatalogBadRequestException("Catalog cannot be a wildcard when namespace is not a wildcard");
            }
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedCatalogName, SecurableType.SECURABLE_TYPE_CATALOG, normalizedNamespaceName, SecurableType.SECURABLE_TYPE_NAMESPACE, normalizedViewName, SecurableType.SECURABLE_TYPE_VIEW), SecurableType.SECURABLE_TYPE_VIEW, List.of(normalizedCatalogName, normalizedNamespaceName, normalizedViewName));
        }
        if (securable.getMaterializedViewName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_CATALOG, SecurableType.SECURABLE_TYPE_NAMESPACE, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW))) {
                throw new CatalogBadRequestException("Materialized view can only be used with catalog or namespace");
            }
            String normalizedMaterializedViewName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_OBJECT, securable.getMaterializedViewName());
            String normalizedNamespaceName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_NAMESPACE, securable.getNamespaceName());
            String normalizedCatalogName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_CATALOG, securable.getCatalogName());
            if (!UnboundSecurableInfo.isWildcard(normalizedMaterializedViewName) && UnboundSecurableInfo.isWildcard(normalizedNamespaceName)) {
                throw new CatalogBadRequestException("Namespace cannot be a wildcard when materialized view is not a wildcard");
            }
            if (!UnboundSecurableInfo.isWildcard(normalizedNamespaceName) && UnboundSecurableInfo.isWildcard(normalizedCatalogName)) {
                throw new CatalogBadRequestException("Catalog cannot be a wildcard when namespace is not a wildcard");
            }
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedCatalogName, SecurableType.SECURABLE_TYPE_CATALOG, normalizedNamespaceName, SecurableType.SECURABLE_TYPE_NAMESPACE, normalizedMaterializedViewName, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW), SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, List.of(normalizedCatalogName, normalizedNamespaceName, normalizedMaterializedViewName));
        }
        if (securable.getNamespaceName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_CATALOG, SecurableType.SECURABLE_TYPE_NAMESPACE))) {
                throw new CatalogBadRequestException("Namespace can only be used with catalog, table, view or materialized view");
            }
            String normalizedNamespaceName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_NAMESPACE, securable.getNamespaceName());
            String normalizedCatalogName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_CATALOG, securable.getCatalogName());
            if (!UnboundSecurableInfo.isWildcard(normalizedNamespaceName) && UnboundSecurableInfo.isWildcard(normalizedCatalogName)) {
                throw new CatalogBadRequestException("Catalog cannot be a wildcard when namespace is not a wildcard");
            }
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedCatalogName, SecurableType.SECURABLE_TYPE_CATALOG, normalizedNamespaceName, SecurableType.SECURABLE_TYPE_NAMESPACE), SecurableType.SECURABLE_TYPE_NAMESPACE, List.of(normalizedCatalogName, normalizedNamespaceName));
        }
        if (securable.getCatalogName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_CATALOG))) {
                throw new CatalogBadRequestException("Catalog can only be used with namespace, table, view or materialized view");
            }
            String normalizedCatalogName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_CATALOG, securable.getCatalogName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedCatalogName, SecurableType.SECURABLE_TYPE_CATALOG), SecurableType.SECURABLE_TYPE_CATALOG, List.of(normalizedCatalogName));
        }
        if (securable.getObjectGroupName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_OBJECT_GROUP))) {
                throw new CatalogBadRequestException("Object group cannot be used with other securables");
            }
            String normalizedObjectGroupName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP, securable.getObjectGroupName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedObjectGroupName, SecurableType.SECURABLE_TYPE_OBJECT_GROUP), SecurableType.SECURABLE_TYPE_OBJECT_GROUP, List.of(normalizedObjectGroupName));
        }
        if (securable.getJobName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, SecurableType.SECURABLE_TYPE_JOB))) {
                throw new CatalogBadRequestException("Job can only be used with compute engine");
            }
            if (securable.getComputeEngineName() != null) {
                String normalizedJobName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_MAINTENANCE_JOB, securable.getJobName());
                String normalizedComputeEngineName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_COMPUTE_ENGINE, securable.getComputeEngineName());
                if (!UnboundSecurableInfo.isWildcard(normalizedJobName) && UnboundSecurableInfo.isWildcard(normalizedComputeEngineName)) {
                    throw new CatalogBadRequestException("Compute engine cannot be a wildcard when job is not a wildcard");
                }
                return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedComputeEngineName, SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, normalizedJobName, SecurableType.SECURABLE_TYPE_JOB), SecurableType.SECURABLE_TYPE_JOB, List.of(normalizedComputeEngineName, normalizedJobName));
            }
            String normalizedJobName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_MAINTENANCE_JOB, securable.getJobName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedJobName, SecurableType.SECURABLE_TYPE_JOB), SecurableType.SECURABLE_TYPE_JOB, List.of(normalizedJobName));
        }
        if (securable.getComputeEngineName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE))) {
                throw new CatalogBadRequestException("Compute engine can only be used with job");
            }
            String normalizedComputeEngineName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_COMPUTE_ENGINE, securable.getComputeEngineName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedComputeEngineName, SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, List.of(normalizedComputeEngineName));
        }
        if (securable.getSecurityProviderName() != null) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER))) {
                throw new CatalogBadRequestException("Security provider cannot be used with other securables");
            }
            String normalizedProviderName = UnboundSecurableInfo.normalizeOrWildcard(CatalogObjectNameValidation.VALIDATION_SECURITY_PROVIDER, securable.getSecurityProviderName());
            return new UnboundSecurableInfo(UnboundSecurableInfo.firstNonWildcard(normalizedProviderName, SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER, List.of(normalizedProviderName));
        }
        if (securable.getMetastore() != null && securable.getMetastore().booleanValue()) {
            if (!UnboundSecurableInfo.checkAllowedComponents(securable, Set.of(SecurableType.SECURABLE_TYPE_METASTORE))) {
                throw new CatalogBadRequestException("Metastore cannot be used with other securables");
            }
            return new UnboundSecurableInfo(SecurableType.SECURABLE_TYPE_METASTORE, SecurableType.SECURABLE_TYPE_METASTORE, List.of());
        }
        throw new CatalogBadRequestException("Securable is not set");
    }

    private static boolean checkAllowedComponents(Securable securable, Set<SecurableType> allowedTypes) {
        HashSet<SecurableType> disallowedTypes = new HashSet<SecurableType>();
        for (SecurableType securableType : SecurableType.values()) {
            if (allowedTypes.contains((Object)securableType)) continue;
            disallowedTypes.add(securableType);
        }
        for (SecurableType disallowedType : disallowedTypes) {
            if (UnboundSecurableInfo.checkDisallowedComponent(securable, disallowedType)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDisallowedComponent(Securable securable, SecurableType disallowedType) {
        return switch (disallowedType) {
            default -> throw new MatchException(null, null);
            case SecurableType.SECURABLE_TYPE_METASTORE -> {
                if (securable.getMetastore() == null || !securable.getMetastore().booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_PRINCIPAL -> {
                if (securable.getPrincipalName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_FILE_SYSTEM -> {
                if (securable.getFileSystemName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_CATALOG -> {
                if (securable.getCatalogName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_NAMESPACE -> {
                if (securable.getNamespaceName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_TABLE -> {
                if (securable.getTableName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_VIEW -> {
                if (securable.getViewName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> {
                if (securable.getMaterializedViewName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_OBJECT_GROUP -> {
                if (securable.getObjectGroupName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE -> {
                if (securable.getComputeEngineName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_JOB -> {
                if (securable.getJobName() == null) {
                    yield true;
                }
                yield false;
            }
            case SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER -> securable.getSecurityProviderName() == null;
        };
    }

    private static String normalizeOrWildcard(CatalogObjectNameValidation validation, String value) {
        return UnboundSecurableInfo.isWildcard(value) ? "*" : validation.normalizeObjectName(value);
    }

    private static boolean isWildcard(String value) {
        return value != null && value.trim().equals("*");
    }

    private static SecurableType firstNonWildcard(String name1, SecurableType type1) {
        return !UnboundSecurableInfo.isWildcard(name1) ? type1 : SecurableType.SECURABLE_TYPE_METASTORE;
    }

    private static SecurableType firstNonWildcard(String name1, SecurableType type1, String name2, SecurableType type2) {
        return !UnboundSecurableInfo.isWildcard(name2) ? type2 : (!UnboundSecurableInfo.isWildcard(name1) ? type1 : SecurableType.SECURABLE_TYPE_METASTORE);
    }

    private static SecurableType firstNonWildcard(String name1, SecurableType type1, String name2, SecurableType type2, String name3, SecurableType type3) {
        return !UnboundSecurableInfo.isWildcard(name3) ? type3 : (!UnboundSecurableInfo.isWildcard(name2) ? type2 : (!UnboundSecurableInfo.isWildcard(name1) ? type1 : SecurableType.SECURABLE_TYPE_METASTORE));
    }
}

