/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckContext;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPrivileges;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;

public class AuthorizationOwnerOrPrivilegeCheck
implements AuthorizationCheck {
    private final Optional<CatalogPrivilege> privilege;
    private final Set<CatalogPrivilege> effectivePrivileges;
    private final Optional<SecurableType> privilegeSecurableType;

    AuthorizationOwnerOrPrivilegeCheck(Optional<CatalogPrivilege> privilege) {
        this.privilege = privilege;
        this.effectivePrivileges = privilege.isPresent() ? CatalogPrivilege.collectEffectivePrivileges(Set.of(privilege.get())) : Set.of();
        this.privilegeSecurableType = privilege.map(CatalogPrivilege::securableType);
    }

    @Override
    public AuthorizationCheck prepare(InternalSecurable securable) {
        return this;
    }

    @Override
    public AuthorizationCheckResultStep check(AuthorizationCheckContext context) {
        boolean result;
        if (this.privilegeSecurableType.isEmpty()) {
            result = AuthorizationOwnerOrPrivilegeCheck.checkOwner(context, context.securable().type());
        } else {
            result = AuthorizationOwnerOrPrivilegeCheck.checkOwner(context, this.privilegeSecurableType.get());
            if (!result) {
                result = AuthorizationOwnerOrPrivilegeCheck.checkPrivileges(context, this.privilegeSecurableType.get(), this.effectivePrivileges);
            }
        }
        return new AuthorizationCheckResultStep(this, result, List.of());
    }

    private static boolean checkOwner(AuthorizationCheckContext context, SecurableType securableType) {
        Optional<UUID> ownerId = context.securable().resolve(securableType).ownerId();
        AuthenticatedPrincipal principal = context.principal();
        return ownerId.isPresent() && principal.roleIds().contains(ownerId.get());
    }

    private static boolean checkPrivileges(AuthorizationCheckContext context, SecurableType securableType, Set<CatalogPrivilege> privileges) {
        Verify.verify((!privileges.isEmpty() ? 1 : 0) != 0);
        Optional<SecurableType> currentSecurableType = Optional.of(securableType);
        while (currentSecurableType.isPresent()) {
            SecurableItem securable = context.securable().resolve(currentSecurableType.get());
            AuthenticatedPrincipal principal = context.principal();
            AuthorizationPrivileges privilegeRegistry = context.privileges();
            for (UUID principalRoleId : principal.roleIds()) {
                for (CatalogPrivilege privilege : privileges) {
                    if (!privilegeRegistry.hasPrivilege(principalRoleId, securable.id(), privilege)) continue;
                    return true;
                }
            }
            currentSecurableType = currentSecurableType.get().parent();
        }
        return false;
    }

    @Override
    public String descriptor(InternalSecurable securable) {
        return this.toString();
    }

    public String toString() {
        return this.privilege.isEmpty() ? "owner" : "privilege[" + this.privilege.get().caption() + "]";
    }
}

