/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Optional;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilegedAction;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckExecutor;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCompositeCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationOwnerOrPrivilegeCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPredefinedRoleCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPrivilegeDynamicCheck;

public class AuthorizationCheckExecutorBuilder {
    private Optional<CatalogPrivilege> privilege = Optional.empty();
    private boolean allowManageGrants;
    private boolean allowPublic;

    public AuthorizationCheckExecutorBuilder allowForPrivilege(CatalogPrivilege privilege) {
        Verify.verify((privilege != null ? 1 : 0) != 0);
        Verify.verify((!this.allowPublic ? 1 : 0) != 0);
        Verify.verify((boolean)this.privilege.isEmpty());
        this.privilege = Optional.of(privilege);
        return this;
    }

    public AuthorizationCheckExecutorBuilder allowForManageGrants() {
        Verify.verify((!this.allowPublic ? 1 : 0) != 0);
        this.allowManageGrants = true;
        return this;
    }

    public AuthorizationCheckExecutorBuilder allowForPublic() {
        Verify.verify((boolean)this.privilege.isEmpty());
        Verify.verify((!this.allowManageGrants ? 1 : 0) != 0);
        this.allowPublic = true;
        return this;
    }

    public AuthorizationCheckExecutor build(CatalogPrivilegedAction action) {
        AuthorizationCheck check = this.buildCheck();
        return new AuthorizationCheckExecutor(action, check);
    }

    private AuthorizationCheck buildCheck() {
        if (this.allowPublic) {
            return new AuthorizationPredefinedRoleCheck("builtin.public");
        }
        ArrayList<AuthorizationCheck> topLevelChecks = new ArrayList<AuthorizationCheck>(2);
        topLevelChecks.add(new AuthorizationPredefinedRoleCheck("builtin.admin"));
        if (this.allowManageGrants) {
            topLevelChecks.add(new AuthorizationOwnerOrPrivilegeCheck(Optional.of(CatalogPrivilege.PRIVILEGE_MANAGE_GRANTS)));
        }
        topLevelChecks.add(new AuthorizationPrivilegeDynamicCheck(new AuthorizationOwnerOrPrivilegeCheck(this.privilege)));
        return AuthorizationCompositeCheck.or(topLevelChecks);
    }
}

