/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilegedAction;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizerServices;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckContext;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResult;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPrivileges;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;

public class AuthorizationCheckExecutor {
    private final CatalogPrivilegedAction action;
    private final AuthorizationCheck check;

    public AuthorizationCheckExecutor(CatalogPrivilegedAction action, AuthorizationCheck check) {
        this.action = action;
        this.check = check;
    }

    public AuthorizationCheckResult execute(AuthenticatedPrincipal principal, InternalSecurable securable, SystemAuthorizerServices services) {
        return this.executeInternal(principal, securable, services, true, true);
    }

    public AuthorizationCheckResult executeForListing(AuthenticatedPrincipal principal, InternalSecurable securable, SystemAuthorizerServices services) {
        return this.executeInternal(principal, securable, services, true, false);
    }

    public AuthorizationCheckResult executeForCheckAccess(AuthenticatedPrincipal principal, InternalSecurable securable, SystemAuthorizerServices services) {
        return this.executeInternal(principal, securable, services, false, true);
    }

    private AuthorizationCheckResult executeInternal(AuthenticatedPrincipal principal, InternalSecurable securable, SystemAuthorizerServices services, boolean shortCircuit, boolean audit) {
        AuthorizationPrivileges privileges = services.privileges();
        AuthorizationCheckContext context = new AuthorizationCheckContext(principal, securable, privileges, services.predefinedRoleIds(), shortCircuit);
        AuthorizationCheck preparedCheck = this.check.prepare(securable);
        AuthorizationCheckResultStep stepResult = preparedCheck.check(context);
        AuthorizationCheckResult result = new AuthorizationCheckResult(this.action, principal, securable, privileges, stepResult);
        if (audit) {
            services.logAuthorizationEvent(result);
        }
        return result;
    }
}

