/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.inject.Inject;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilegedAction;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizerServices;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckExecutor;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResult;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerCatalogPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerComputeEnginePredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerFileSystemPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerJobPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerNamespacePredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerObjectGroupPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerObjectPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerPrincipalPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerSecurityProviderPredicate;
import ru.cedrusdata.catalog.core.security.authorization.securable.CatalogInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ComputeEngineInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.FileSystemInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.JobInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.MetastoreInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectGroupInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.PrincipalInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurityProviderInternalSecurable;

public class SystemAuthorizer
implements Authorizer {
    private final SystemAuthorizerServices services;

    @Inject
    public SystemAuthorizer(SystemAuthorizerServices services) {
        this.services = services;
    }

    @Override
    public void authorizeManagementRead(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_READ_METRICS, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizePrincipalCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizePrincipalAlter(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_ALTER, principal, securablePrincipal);
    }

    @Override
    public void authorizePrincipalDrop(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_DROP, principal, securablePrincipal);
    }

    @Override
    public void authorizePrincipalImpersonate(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_IMPERSONATE, principal, securablePrincipal);
    }

    @Override
    public void authorizePrincipalDescribe(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_DESCRIBE, principal, securablePrincipal);
    }

    @Override
    public AuthorizerPrincipalPredicate authorizePrincipalList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_PRINCIPAL_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizePrincipalCreateAccessToken(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_CREATE_ACCESS_TOKEN, principal, securablePrincipal);
    }

    @Override
    public void authorizePrincipalDropAccessToken(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_DROP_ACCESS_TOKEN, principal, securablePrincipal);
    }

    @Override
    public AuthorizerPrincipalPredicate authorizePrincipalListAccessTokens(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_PRINCIPAL_LIST_ACCESS_TOKENS, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_PRINCIPAL_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeRoleGrant(AuthenticatedPrincipal principal, PrincipalInternalSecurable role) {
        this.check(CatalogPrivilegedAction.ACTION_ROLE_GRANT, principal, role);
    }

    @Override
    public void authorizeRoleRevoke(AuthenticatedPrincipal principal, PrincipalInternalSecurable role) {
        this.check(CatalogPrivilegedAction.ACTION_ROLE_REVOKE, principal, role);
    }

    @Override
    public void authorizeRoleListMembers(AuthenticatedPrincipal principal, PrincipalInternalSecurable role) {
        this.check(CatalogPrivilegedAction.ACTION_ROLE_LIST_MEMBERS, principal, role);
    }

    @Override
    public void authorizePrivilegeGrant(AuthenticatedPrincipal principal, InternalSecurable securable) {
        this.check(CatalogPrivilegedAction.ACTION_PRIVILEGE_GRANT, principal, securable);
    }

    @Override
    public void authorizePrivilegeRevoke(AuthenticatedPrincipal principal, InternalSecurable securable) {
        this.check(CatalogPrivilegedAction.ACTION_PRIVILEGE_REVOKE, principal, securable);
    }

    @Override
    public void authorizePrivilegeListPrincipalGrants(AuthenticatedPrincipal principal, PrincipalInternalSecurable securablePrincipal) {
        this.check(CatalogPrivilegedAction.ACTION_PRIVILEGE_LIST_PRINCIPAL_GRANTS, principal, securablePrincipal);
    }

    @Override
    public void authorizePrivilegeListSecurableGrants(AuthenticatedPrincipal principal, InternalSecurable securable) {
        this.check(CatalogPrivilegedAction.ACTION_PRIVILEGE_LIST_SECURABLE_GRANTS, principal, securable);
    }

    @Override
    public void authorizeGrantOwnership(AuthenticatedPrincipal principal, InternalSecurable securable) {
        this.check(CatalogPrivilegedAction.ACTION_GRANT_OWNERSHIP, principal, securable);
    }

    @Override
    public void authorizeFileSystemCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizeFileSystemAlter(AuthenticatedPrincipal principal, FileSystemInternalSecurable fileSystem) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_ALTER, principal, fileSystem);
    }

    @Override
    public void authorizeFileSystemDrop(AuthenticatedPrincipal principal, FileSystemInternalSecurable fileSystem) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_DROP, principal, fileSystem);
    }

    @Override
    public void authorizeFileSystemDescribe(AuthenticatedPrincipal principal, FileSystemInternalSecurable fileSystem) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_DESCRIBE, principal, fileSystem);
    }

    @Override
    public void authorizeFileSystemCheck(AuthenticatedPrincipal principal, FileSystemInternalSecurable fileSystem) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_CHECK, principal, fileSystem);
    }

    @Override
    public AuthorizerFileSystemPredicate authorizeFileSystemList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_FILE_SYSTEM_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_FILE_SYSTEM_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeCatalogCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizeCatalogAlter(AuthenticatedPrincipal principal, CatalogInternalSecurable catalog) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_ALTER, principal, catalog);
    }

    @Override
    public void authorizeCatalogDrop(AuthenticatedPrincipal principal, CatalogInternalSecurable catalog) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_DROP, principal, catalog);
    }

    @Override
    public void authorizeCatalogDescribe(AuthenticatedPrincipal principal, CatalogInternalSecurable catalog) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_DESCRIBE, principal, catalog);
    }

    @Override
    public void authorizeCatalogCheck(AuthenticatedPrincipal principal, CatalogInternalSecurable catalog) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_CHECK, principal, catalog);
    }

    @Override
    public AuthorizerCatalogPredicate authorizeCatalogList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_CATALOG_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_CATALOG_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeNamespaceCreate(AuthenticatedPrincipal principal, CatalogInternalSecurable catalog) {
        this.check(CatalogPrivilegedAction.ACTION_NAMESPACE_CREATE, principal, catalog);
    }

    @Override
    public void authorizeNamespaceAlter(AuthenticatedPrincipal principal, NamespaceInternalSecurable namespace) {
        this.check(CatalogPrivilegedAction.ACTION_NAMESPACE_ALTER, principal, namespace);
    }

    @Override
    public void authorizeNamespaceDrop(AuthenticatedPrincipal principal, NamespaceInternalSecurable namespace) {
        this.check(CatalogPrivilegedAction.ACTION_NAMESPACE_DROP, principal, namespace);
    }

    @Override
    public void authorizeNamespaceDescribe(AuthenticatedPrincipal principal, NamespaceInternalSecurable namespace) {
        this.check(CatalogPrivilegedAction.ACTION_NAMESPACE_DESCRIBE, principal, namespace);
    }

    @Override
    public AuthorizerNamespacePredicate authorizeNamespaceList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_NAMESPACE_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_NAMESPACE_DESCRIBE.executor();
        return namespaceSecurable -> executor.executeForListing(principal, namespaceSecurable, this.services).allowed();
    }

    @Override
    public void authorizeObjectCreate(AuthenticatedPrincipal principal, NamespaceInternalSecurable namespace, AuthorizerObjectType objectType) {
        this.check(objectType.createAction(), principal, namespace);
    }

    @Override
    public void authorizeObjectAlter(AuthenticatedPrincipal principal, ObjectInternalSecurable object) {
        this.check(AuthorizerObjectType.fromSecurableType(object.type()).alterAction(), principal, object);
    }

    @Override
    public void authorizeObjectDrop(AuthenticatedPrincipal principal, ObjectInternalSecurable object) {
        this.check(AuthorizerObjectType.fromSecurableType(object.type()).dropAction(), principal, object);
    }

    @Override
    public void authorizeObjectModify(AuthenticatedPrincipal principal, ObjectInternalSecurable object) {
        this.check(AuthorizerObjectType.fromSecurableType(object.type()).modifyAction(), principal, object);
    }

    @Override
    public void authorizeObjectDescribe(AuthenticatedPrincipal principal, ObjectInternalSecurable object) {
        this.check(AuthorizerObjectType.fromSecurableType(object.type()).usageAction(), principal, object);
    }

    @Override
    public AuthorizerObjectPredicate authorizeObjectList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        return securable -> AuthorizerObjectType.fromSecurableType(securable.type()).usageAction().executor().executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeObjectGroupCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizeObjectGroupAlter(AuthenticatedPrincipal principal, ObjectGroupInternalSecurable objectGroup) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_ALTER, principal, objectGroup);
    }

    @Override
    public void authorizeObjectGroupDrop(AuthenticatedPrincipal principal, ObjectGroupInternalSecurable objectGroup) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_DROP, principal, objectGroup);
    }

    @Override
    public void authorizeObjectGroupDescribe(AuthenticatedPrincipal principal, ObjectGroupInternalSecurable objectGroup) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_DESCRIBE, principal, objectGroup);
    }

    @Override
    public AuthorizerObjectGroupPredicate authorizeObjectGroupList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_OBJECT_GROUP_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public AuthorizerObjectPredicate authorizeObjectGroupListObjects(AuthenticatedPrincipal principal, ObjectGroupInternalSecurable objectGroup) {
        this.check(CatalogPrivilegedAction.ACTION_OBJECT_GROUP_LIST_OBJECTS, principal, objectGroup);
        return securable -> AuthorizerObjectType.fromSecurableType(securable.type()).usageAction().executor().executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeComputeEngineCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizeComputeEngineAlter(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_ALTER, principal, computeEngine);
    }

    @Override
    public void authorizeComputeEngineDrop(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_DROP, principal, computeEngine);
    }

    @Override
    public void authorizeComputeEngineCheck(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_CHECK, principal, computeEngine);
    }

    @Override
    public void authorizeComputeEngineDescribe(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_DESCRIBE, principal, computeEngine);
    }

    @Override
    public void authorizeComputeEngineStartOperation(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_START_OPERATION, principal, computeEngine);
    }

    @Override
    public void authorizeComputeEngineCancelOperation(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_CANCEL_OPERATION, principal, computeEngine);
    }

    @Override
    public AuthorizerComputeEnginePredicate authorizeComputeEngineList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public AuthorizerComputeEnginePredicate authorizeComputeEngineListOperations(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_LIST_OPERATIONS, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_COMPUTE_ENGINE_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeJobCreate(AuthenticatedPrincipal principal, ComputeEngineInternalSecurable computeEngine) {
        this.check(CatalogPrivilegedAction.ACTION_JOB_CREATE, principal, computeEngine);
    }

    @Override
    public void authorizeJobAlter(AuthenticatedPrincipal principal, JobInternalSecurable job) {
        this.check(CatalogPrivilegedAction.ACTION_JOB_ALTER, principal, job);
    }

    @Override
    public void authorizeJobDrop(AuthenticatedPrincipal principal, JobInternalSecurable job) {
        this.check(CatalogPrivilegedAction.ACTION_JOB_DROP, principal, job);
    }

    @Override
    public void authorizeJobDescribe(AuthenticatedPrincipal principal, JobInternalSecurable job) {
        this.check(CatalogPrivilegedAction.ACTION_JOB_DESCRIBE, principal, job);
    }

    @Override
    public AuthorizerJobPredicate authorizeJobList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_JOB_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_JOB_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeSecurityProviderCreate(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_CREATE, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
    }

    @Override
    public void authorizeSecurityProviderAlter(AuthenticatedPrincipal principal, SecurityProviderInternalSecurable securityProvider) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_ALTER, principal, securityProvider);
    }

    @Override
    public void authorizeSecurityProviderDrop(AuthenticatedPrincipal principal, SecurityProviderInternalSecurable securityProvider) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_DROP, principal, securityProvider);
    }

    @Override
    public void authorizeSecurityProviderCheck(AuthenticatedPrincipal principal, SecurityProviderInternalSecurable securityProvider) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_CHECK, principal, securityProvider);
    }

    @Override
    public void authorizeSecurityProviderDescribe(AuthenticatedPrincipal principal, SecurityProviderInternalSecurable securityProvider) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_DESCRIBE, principal, securityProvider);
    }

    @Override
    public AuthorizerSecurityProviderPredicate authorizeSecurityProviderList(AuthenticatedPrincipal principal) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_LIST, principal, MetastoreInternalSecurable.METASTORE_SECURABLE);
        AuthorizationCheckExecutor executor = CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_DESCRIBE.executor();
        return securable -> executor.executeForListing(principal, securable, this.services).allowed();
    }

    @Override
    public void authorizeSecurityProviderUse(AuthenticatedPrincipal principal, SecurityProviderInternalSecurable securityProvider) {
        this.check(CatalogPrivilegedAction.ACTION_SECURITY_PROVIDER_USE, principal, securityProvider);
    }

    @Override
    public AuthorizationCheckResult checkAccess(AuthenticatedPrincipal principal, CatalogPrivilegedAction action, InternalSecurable securable) {
        return action.executor().executeForCheckAccess(principal, securable, this.services);
    }

    private void check(CatalogPrivilegedAction action, AuthenticatedPrincipal principal, InternalSecurable securable) {
        action.executor().execute(principal, securable, this.services).enforce();
    }
}

