/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.maintenance;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import ru.cedrusdata.catalog.core.PageData;
import ru.cedrusdata.catalog.core.ResultPageIterator;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationObject;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationObjectGroup;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetailsListResultForMaintenance;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationObjectType;

class ObjectGroupIterator
extends ResultPageIterator<MaintenanceOperationObject> {
    ObjectGroupIterator(AuthenticatedPrincipal principal, MaintenanceOperationObjectGroup objectGroup, CedrusDataIcebergObjectType type, ObjectGroupService objectGroupService, int pageSize) {
        super(resultPage -> {
            ObjectGroupObjectDetailsListResultForMaintenance result = objectGroupService.listObjectsForMaintenance(principal, objectGroup.objectGroupName(), objectGroup.objectGroupId(), type, ResultPage.fromQueryParams((String)resultPage.pageToken().orElse(null), null));
            return new PageData<MaintenanceOperationObject>(result.items(), result.nextPageToken());
        }, pageSize);
    }

    static Iterator<MaintenanceOperationObject> createForOperation(CatalogComputeEngineOperationFactory operationFactory, AuthenticatedPrincipal principal, MaintenanceOperationObjectGroup objectGroup, ObjectGroupService objectGroupService, int pageSize) {
        ArrayList<ObjectGroupIterator> iterators = new ArrayList<ObjectGroupIterator>();
        for (CatalogComputeEngineOperationObjectType engineType : operationFactory.supportedObjectTypes()) {
            CedrusDataIcebergObjectType type = switch (engineType) {
                default -> throw new MatchException(null, null);
                case CatalogComputeEngineOperationObjectType.ICEBERG_TABLE -> CedrusDataIcebergObjectType.TABLE;
                case CatalogComputeEngineOperationObjectType.ICEBERG_CEDRUSDATA_MATERIALIZED_VIEW -> CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW;
            };
            iterators.add(new ObjectGroupIterator(principal, objectGroup, type, objectGroupService, pageSize));
        }
        return Iterators.concat(iterators.iterator());
    }
}

