/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine.local;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.PropertyUtil;
import ru.cedrusdata.catalog.core.computeengine.local.BatchDelete;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationContext;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileEntry;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileIterator;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;

public class LocalRemoveOrphanFilesOperation
implements CatalogComputeEngineOperation {
    private static final int MAX_SUPPORTED_TABLE_VERSION = 2;
    private final CatalogFileSystem fileSystem;
    private final Table table;
    private final Instant expireOlderThan;

    public LocalRemoveOrphanFilesOperation(CatalogFileSystem fileSystem, Table table, Instant expireOlderThan) {
        this.fileSystem = fileSystem;
        this.table = table;
        this.expireOlderThan = expireOlderThan;
    }

    public Map<String, String> execute(CatalogComputeEngineOperationContext operationContext) {
        Map properties = this.table.properties();
        if (!PropertyUtil.propertyAsBoolean((Map)properties, (String)"gc.enabled", (boolean)true)) {
            return LocalRemoveOrphanFilesOperation.createResult(0);
        }
        int formatVersion = ((HasTableOperations)this.table).operations().current().formatVersion();
        if (formatVersion > 2) {
            throw new UnsupportedOperationException(String.format("Not supported for Iceberg table format version > %d. Table format version: %d", 2, formatVersion));
        }
        if (this.table.currentSnapshot() == null) {
            return LocalRemoveOrphanFilesOperation.createResult(0);
        }
        String metadataLocation = properties.getOrDefault("write.metadata.path", String.format("%s/metadata", this.table.location()));
        String dataLocation = properties.getOrDefault("write.data.path", String.format("%s/data", this.table.location()));
        if (dataLocation.startsWith(metadataLocation) || metadataLocation.startsWith(dataLocation)) {
            throw new IllegalStateException(String.format("Overlapping metadata and data locations: %s and %s", metadataLocation, dataLocation));
        }
        return this.execute(dataLocation, metadataLocation);
    }

    private Map<String, String> execute(String dataLocation, String metadataLocation) {
        ImmutableSet.Builder validMetadataFiles = ImmutableSet.builder();
        ImmutableSet.Builder validDataFiles = ImmutableSet.builder();
        HashSet<String> processedManifestFilePaths = new HashSet<String>();
        for (Snapshot snapshot : this.table.snapshots()) {
            if (snapshot.manifestListLocation() != null) {
                validMetadataFiles.add((Object)LocalRemoveOrphanFilesOperation.fileName(snapshot.manifestListLocation()));
            }
            for (ManifestFile manifest : snapshot.allManifests(this.table.io())) {
                if (!processedManifestFilePaths.add(LocalRemoveOrphanFilesOperation.fileName(manifest.path()))) continue;
                validMetadataFiles.add((Object)LocalRemoveOrphanFilesOperation.fileName(manifest.path()));
                try {
                    ManifestReader<? extends ContentFile<?>> manifestReader = this.readerForManifest(this.table, manifest);
                    try {
                        for (ContentFile contentFile : manifestReader) {
                            validDataFiles.add((Object)LocalRemoveOrphanFilesOperation.fileName(contentFile.path().toString()));
                        }
                    }
                    finally {
                        if (manifestReader == null) continue;
                        manifestReader.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to list manifest file content from " + manifest.path(), e);
                }
            }
        }
        validMetadataFiles.add((Object)"version-hint.text");
        ReachableFileUtil.statisticsFilesLocations((Table)this.table).forEach(location -> validMetadataFiles.add((Object)LocalRemoveOrphanFilesOperation.fileName(location)));
        ReachableFileUtil.metadataFileLocations((Table)this.table, (boolean)false).forEach(location -> validMetadataFiles.add((Object)LocalRemoveOrphanFilesOperation.fileName(location)));
        BatchDelete batchDelete = new BatchDelete(this.fileSystem, true);
        this.findAndDeleteOrphanFiles(this.fileSystem, batchDelete, dataLocation, (Set<String>)validDataFiles.build());
        this.findAndDeleteOrphanFiles(this.fileSystem, batchDelete, metadataLocation, (Set<String>)validMetadataFiles.build());
        int deletedFilesCount = batchDelete.finish();
        return LocalRemoveOrphanFilesOperation.createResult(deletedFilesCount);
    }

    private void findAndDeleteOrphanFiles(CatalogFileSystem fileSystem, BatchDelete batchDelete, String location, Set<String> validFiles) {
        try {
            CatalogFileIterator iterator = fileSystem.listFiles(location);
            while (iterator.hasNext()) {
                CatalogFileEntry file = iterator.next();
                if (!file.lastModified().isBefore(this.expireOlderThan) || validFiles.contains(LocalRemoveOrphanFilesOperation.fileName(file.location()))) continue;
                batchDelete.accept(file.location());
            }
        }
        catch (IOException e) {
            String message = String.format("Failed to list table files in location %s", location);
            throw new UncheckedIOException(message, e);
        }
    }

    private ManifestReader<? extends ContentFile<?>> readerForManifest(Table table, ManifestFile manifest) {
        return switch (manifest.content()) {
            default -> throw new MatchException(null, null);
            case ManifestContent.DATA -> ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io());
            case ManifestContent.DELETES -> ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)table.io(), (Map)table.specs());
        };
    }

    private static String fileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static Map<String, String> createResult(int deletedFilesCount) {
        return Map.of("deleted-files", Integer.toString(deletedFilesCount));
    }
}

