/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.ComputeEngineInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.plugin.ExtensionPropertyClassifier;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;

public record ComputeEngineDetails(UUID id, String name, String description, CatalogComputeEngineType type, Map<String, String> properties, Optional<UUID> ownerId, Optional<String> ownerName) {
    public ComputeEngineInfo info(ExtensionPropertyClassifier<CatalogComputeEngineType> propertyClassifier, List<ComputeEngineOperationMetadata> operations) {
        ImmutableMap.Builder finalProperties = ImmutableMap.builder();
        ImmutableSet.Builder finalRedactedProperties = ImmutableSet.builder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (propertyClassifier.shouldRedact(this.type, key)) {
                finalRedactedProperties.add((Object)key);
                continue;
            }
            finalProperties.put((Object)key, (Object)entry.getValue());
        }
        return new ComputeEngineInfo(this.name, this.type.name(), this.description, (Map)finalProperties.buildOrThrow(), (Set)finalRedactedProperties.build(), (String)this.ownerName.orElse(null), operations);
    }

    public ComputeEngineInternalSecurable toSecurable() {
        return new ComputeEngineInternalSecurable(new SecurableItem(this.id, this.ownerId, this.name));
    }
}

