/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ApiMethodStats {
    private final CounterStat requests = new CounterStat();
    private final CounterStat failures = new CounterStat();
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V, E extends Exception> V wrap(ThrowingCallable<V, E> callable) throws E {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            this.requests.update(1L);
            V v = callable.call();
            return v;
        }
        catch (Throwable e) {
            this.failures.update(1L);
            throw e;
        }
    }

    public <E extends Exception> void wrap(ThrowingRunnable<E> callable) throws E {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            this.requests.update(1L);
            callable.run();
        }
        catch (Throwable e) {
            this.failures.update(1L);
            throw e;
        }
    }

    @Managed
    @Nested
    public CounterStat getRequests() {
        return this.requests;
    }

    @Managed
    @Nested
    public CounterStat getFailures() {
        return this.failures;
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    public static interface ThrowingCallable<V, E extends Exception> {
        public V call() throws E;
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

