/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.SecurityContext;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.catalog.Namespace;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.server.security.BasicAuthentication;
import ru.cedrusdata.catalog.server.security.CatalogPrincipal;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthenticationException;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogPropertyConflictException;
import ru.cedrusdata.catalog.spi.exception.CatalogUnsupportedOperationException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;

public final class CatalogUtils {
    public static final String WILDCARD = "*";
    private static final AuthenticatedPrincipal ANONYMOUS_PRINCIPAL = new AuthenticatedPrincipal(new UUID(0L, 0L), "<anonymous>", Optional.empty(), Set.of(), true);
    private static final AuthenticationContext ANONYMOUS_CONTEXT = new AuthenticationContext(ANONYMOUS_PRINCIPAL, ANONYMOUS_PRINCIPAL);
    public static final String ICEBERG_ENDPOINT_BASE = "/catalog/iceberg/v1";
    public static final String HEADER_ICEBERG_ACCESS_DELEGATION = "X-Iceberg-Access-Delegation";
    public static final String ICEBERG_CATALOG_PROPERTY_PREFIX = "prefix";
    public static final String ICEBERG_CATALOG_PROPERTY_LOCATION = "location";
    public static final String ICEBERG_CATALOG_PROPERTY_VIEW_ENDPOINTS_SUPPORTED = "view-endpoints-supported";
    public static final String ICEBERG_CATALOG_PROPERTY_METRICS_REPORTING_ENABLED = "rest-metrics-reporting-enabled";
    public static final int BCRYPT_MAX_PASSWORD_LENGTH = 72;
    private static final String BASIC = "Basic";
    private static final String BEARER = "Bearer";
    private static final String AUTH_SCHEME_CEDRUSDATA_CATALOG = "cedrusdata.catalog";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] RANDOMIZED_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-abcdefghijklmnopqrstuvwxyz_1234567890".toCharArray();
    private static final int BCRYPT_COST = 10;

    private CatalogUtils() {
    }

    public static Optional<BasicAuthentication> extractBasic(String authorization) {
        if (authorization != null && authorization.startsWith(BASIC)) {
            String encodedContent = authorization.substring(BASIC.length()).trim();
            String content = new String(Base64.getDecoder().decode(encodedContent), StandardCharsets.ISO_8859_1);
            int index = content.indexOf(":");
            if (index != -1) {
                String principal = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.normalizeObjectName(content.substring(0, index));
                String password = content.substring(index + 1);
                return Optional.of(new BasicAuthentication(principal, password));
            }
        }
        return Optional.empty();
    }

    public static Optional<String> extractBearer(String authorization) {
        String token;
        if (authorization != null && authorization.startsWith(BEARER) && !(token = authorization.substring(BEARER.length()).trim()).isEmpty()) {
            return Optional.of(token);
        }
        return Optional.empty();
    }

    public static void setAuthenticationContext(ContainerRequestContext request, AuthenticationContext context) {
        final boolean secure = request.getSecurityContext().isSecure();
        final CatalogPrincipal contextPrincipal = new CatalogPrincipal(context);
        request.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return contextPrincipal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return secure;
            }

            public String getAuthenticationScheme() {
                return CatalogUtils.AUTH_SCHEME_CEDRUSDATA_CATALOG;
            }
        });
    }

    public static AuthenticationContext getAuthenticationContext(SecurityContext securityContext) {
        AuthenticationContext context = CatalogUtils.getAuthenticationContextInternal(securityContext);
        if (context != null) {
            return context;
        }
        throw new CatalogAuthenticationException();
    }

    public static AuthenticationContext getAuthenticatedContextOrAnonymous(SecurityContext securityContext) {
        AuthenticationContext context = CatalogUtils.getAuthenticationContextInternal(securityContext);
        return context != null ? context : ANONYMOUS_CONTEXT;
    }

    private static AuthenticationContext getAuthenticationContextInternal(SecurityContext securityContext) {
        if (securityContext == null) {
            return null;
        }
        Principal principal = securityContext.getUserPrincipal();
        if (principal instanceof CatalogPrincipal) {
            CatalogPrincipal catalogPrincipal = (CatalogPrincipal)principal;
            return catalogPrincipal.context();
        }
        return null;
    }

    public static String generateRandomString(int length) {
        Verify.verify((length > 0 ? 1 : 0) != 0);
        char[] res = new char[length];
        for (int i = 0; i < length; ++i) {
            res[i] = RANDOMIZED_ALPHABET[RANDOM.nextInt(RANDOMIZED_ALPHABET.length)];
        }
        return new String(res);
    }

    public static String hashPassword(String password) {
        if ((password = CatalogUtils.normalizeNotEmpty(password, "Password cannot be empty")).length() > 72) {
            throw new CatalogBadRequestException("Password length cannot be greater than 72");
        }
        return BCrypt.with((BCrypt.Version)BCrypt.Version.VERSION_2A).hashToString(10, password.toCharArray());
    }

    public static boolean passwordMatches(String password, Optional<String> hashedPassword) {
        return hashedPassword.isPresent() && BCrypt.verifyer().verify((char[])password.toCharArray(), (CharSequence)((CharSequence)hashedPassword.get())).verified;
    }

    public static String flattenIcebergNamespace(Namespace namespace) {
        if (namespace.length() != 1) {
            throw new CatalogUnsupportedOperationException("Nested namespaces are not supported");
        }
        return namespace.level(0);
    }

    public static Map<String, String> mergeProperties(Map<String, String> properties, Map<String, String> addedProperties, Set<String> removedProperties) {
        if (properties == null) {
            properties = Map.of();
        }
        if (addedProperties == null) {
            addedProperties = Map.of();
        }
        if (removedProperties == null) {
            removedProperties = Set.of();
        }
        HashMap<String, String> res = new HashMap<String, String>(properties);
        for (String key : removedProperties) {
            if (addedProperties.containsKey(key)) {
                throw new CatalogPropertyConflictException(key);
            }
            res.remove(key);
        }
        res.putAll(addedProperties);
        return ImmutableMap.copyOf(res);
    }

    public static String normalizeNotEmpty(String value, String errorMessage) {
        if (CatalogUtils.isNullOrEmpty(value)) {
            throw new CatalogBadRequestException(errorMessage);
        }
        return value.trim();
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static CatalogFileSystemType resolveFileSystemType(String typeStr) {
        typeStr = CatalogUtils.normalizeNotEmpty(typeStr, "File system type cannot be empty");
        for (CatalogFileSystemType type : CatalogFileSystemType.values()) {
            if (!type.name().equalsIgnoreCase(typeStr)) continue;
            return type;
        }
        throw new CatalogBadRequestException(String.format("Unsupported file system type \"%s\"", typeStr));
    }

    public static CatalogComputeEngineType resolveComputeEngineType(String typeStr) {
        typeStr = CatalogUtils.normalizeNotEmpty(typeStr, "Compute engine type cannot be empty");
        for (CatalogComputeEngineType type : CatalogComputeEngineType.values()) {
            if (!type.name().equalsIgnoreCase(typeStr)) continue;
            return type;
        }
        throw new CatalogBadRequestException(String.format("Unsupported compute engine type \"%s\"", typeStr));
    }
}

