/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public enum CatalogObjectNameValidation {
    VALIDATION_PRINCIPAL("Principal name", true),
    VALIDATION_ROLE("Role name", true),
    VALIDATION_GRANTOR("Grantor name", true),
    VALIDATION_FILE_SYSTEM("File system name", false),
    VALIDATION_CATALOG("Iceberg catalog name", false),
    VALIDATION_NAMESPACE("Iceberg namespace name", false),
    VALIDATION_OBJECT("Iceberg object name", false),
    VALIDATION_OBJECT_GROUP("Iceberg object group name", false),
    VALIDATION_COMPUTE_ENGINE("Compute engine name", false),
    VALIDATION_MAINTENANCE_JOB("Maintenance job name", false),
    VALIDATION_SECURITY_PROVIDER("Security provider name", false);

    private static final Pattern PRINCIPAL_NAME_PATTERN;
    private static final Pattern OBJECT_NAME_PATTERN;
    private final String capitalLetterCaption;
    private final String lowerLetterCaption;
    private final boolean principal;

    private CatalogObjectNameValidation(String caption, boolean principal) {
        this.capitalLetterCaption = Character.toUpperCase(caption.charAt(0)) + caption.substring(1);
        this.lowerLetterCaption = Character.toLowerCase(caption.charAt(0)) + caption.substring(1);
        this.principal = principal;
    }

    public String normalizeObjectName(String name) throws CatalogException {
        if (name == null || name.trim().isEmpty()) {
            throw new CatalogBadRequestException(String.format("%s cannot be empty", this.capitalLetterCaption));
        }
        name = name.trim();
        if (this.principal) {
            if (!PRINCIPAL_NAME_PATTERN.matcher(name).matches()) {
                throw new CatalogBadRequestException(String.format("%s \"%s\" must contain only alphanumeric characters, \"_\", \"-\", \".\", or \"@\"", this.capitalLetterCaption, name));
            }
        } else if (!OBJECT_NAME_PATTERN.matcher(name).matches()) {
            throw new CatalogBadRequestException(String.format("%s \"%s\" must contain only alphanumeric characters and underscores", this.capitalLetterCaption, name));
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public Optional<String> normalizeOptionalObjectName(Optional<String> name) {
        if (name.isEmpty()) {
            return name;
        }
        return Optional.of(this.normalizeObjectName(name.get()));
    }

    public Optional<String> normalizeOptionalObjectName(String name) {
        return this.normalizeOptionalObjectName(Optional.ofNullable(name));
    }

    public CatalogBadRequestException invalidValue(String message) {
        throw new CatalogBadRequestException(String.format("Invalid %s: %s", this.lowerLetterCaption, message));
    }

    public String decodeString(String objectName) {
        try {
            return RESTUtil.decodeString((String)objectName);
        }
        catch (Exception e) {
            throw new CatalogBadRequestException(String.format("Invalid %s: %s", this.lowerLetterCaption, e.getMessage()), (Throwable)e);
        }
    }

    public Optional<String> decodeOptionalString(String objectName) {
        return objectName != null ? Optional.of(this.decodeString(objectName)) : Optional.empty();
    }

    public static Namespace decodeIcebergNamespace(String namespaceName) {
        try {
            return RESTUtil.decodeNamespace((String)namespaceName);
        }
        catch (Exception e) {
            throw new CatalogBadRequestException(String.format("Invalid %s: %s", CatalogObjectNameValidation.VALIDATION_NAMESPACE.lowerLetterCaption, e.getMessage()), (Throwable)e);
        }
    }

    public static Optional<Namespace> decodeOptionalIcebergNamespace(String namespaceName) {
        return namespaceName != null ? Optional.of(CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName)) : Optional.empty();
    }

    static {
        PRINCIPAL_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-.@$]*");
        OBJECT_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_$]*");
    }
}

